package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.lang.Functions;
import ssmith.util.CSVString;
import ssmith.astar.WayPoints;
import java.awt.Point;
import java.io.IOException;
import ngrave.ai.Wander90AI;
import ngrave.client.Client;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SBarrel;
import ngrave.server.objects.SCrate;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectPrisoner;
import ngrave.server.objects.SPlayerObjectTrooper;
import ngrave.server.objects.SPlayerObjectZeeker;

public class RescueFromTheMines
extends Mission {

	private WayPoints attacker_start_positions = new WayPoints();
	private WayPoints defender_start_positions = new WayPoints();
	private WayPoints prisoner_start_positions = new WayPoints();

	public String getMissionTitle() {
		return "Rescue from the Mines";
	}

	public boolean randomMap() {
		return false;
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public int getMaxTime() {
		return -1;
	}

	public void timeExpired() {
	}

	public String getMissionBriefing(byte side) {
		switch(side) {
		case 0:
			return "The defenders have taken 3 hostages and placed them in 3 of the cells contained around the mine.  You must rescue them by bringing them back to the blue exit hatch.\n\nYou will need at least 3 grenades with which to blow open the cell doors.";
		case 1:
			return "The attackers are trying to rescue the 3 hostages you have taken.  You must kill all the rescuers before they succeed.";
		default:
			return "";
		}
	}

	public int getCredits(byte side) {
		switch (side) {
		case 0:
			return 240;
		default:
			return 180;
		}
	}

	public boolean wallsCanBeDestroyed() {
		return true;
	}

	public void setupForClient() {
	}

	public void setupForServer() {
		TextFile tf = new TextFile();
		try {
			tf.openFile(Client.MISSION_DIR + "rescuefromthemines.csv", TextFile.READ);
			CSVString line = new CSVString(tf.readLine());
			byte size = new Byte(line.getFirstSection()).byteValue();
			Server.map = new SMapData(size);
			for (byte z = 0; z < size; z++) {
				line = new CSVString(tf.readLine());
				//System.out.println(line.toString());
				for (byte x = 0; x < size; x++) {
					byte b = new Byte(line.getSection(x)).byteValue();
					if (b == 98) {
						this.prisoner_start_positions.add(x, z);
						b = SMapSquare.FLOOR;
					} else if (b == 99) {
						this.defender_start_positions.add(x, z);
						b = SMapSquare.FLOOR;
					} else if (b == 97) {
						this.attacker_start_positions.add(x, z);
						b = SMapSquare.FLOOR;
					}
					SMapSquare.MapSquareFactory(Server.map, x, z, b);
				}
			}
			tf.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		// Place barrels
		int MAX_BARRELS = 15;
		while (MAX_BARRELS > 0) {
			int x = Functions.rnd(5, Server.map.size -5);
			int z = Functions.rnd(5, Server.map.size -5);
			if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
				new SBarrel(x+0.5f, z+0.5f);
				MAX_BARRELS--;
			}
		}

		// Place crates
		MAX_BARRELS = 15;
		while (MAX_BARRELS > 0) {
			int x = Functions.rnd(5, Server.map.size -5);
			int z = Functions.rnd(5, Server.map.size -5);
			if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
				new SCrate(x+0.5f, z+0.5f);
				MAX_BARRELS--;
			}
		}

		// Place troops
		SPlayerObject3D trooper = null;
		for (int q=0 ; q<5 ; q++) {
			Point p = this.getRandomAttackerPosition();
			trooper = new SPlayerObjectTrooper(Client.ATTACKER, p.x + 0.5f, p.y + 0.5f);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

		for (int q=0 ; q<3 ; q++) {
			Point p = this.getRandomPrisonerPosition();
			trooper = new SPlayerObjectPrisoner(Client.ATTACKER, p.x + 0.5f, p.y + 0.5f);
		}

		for (int q=0 ; q<4 ; q++) {
			Point p = this.getRandomDefenderPosition();
			trooper = new SPlayerObjectTrooper(Client.DEFENDER, p.x + 0.5f, p.y + 0.5f);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.setArmour(18);
			}
			//}
		}

		for (int q=0 ; q<4 ; q++) {
			Point p = this.getRandomDefenderPosition();
			trooper = new SPlayerObjectZeeker(Client.DEFENDER, p.x + 0.5f, p.y + 0.5f);
		}

	}

	private Point getRandomAttackerPosition() {
		//int i = Functions.rnd(0, attacker_start_positions.size() - 1);
		Point p = attacker_start_positions.getRandomPoint(true);
		//attacker_start_positions.remove(i);
		return p;
	}

	private Point getRandomDefenderPosition() {
		//int i = Functions.rnd(0, defender_start_positions.size() - 1);
		Point p = defender_start_positions.getRandomPoint(true);
		//defender_start_positions.remove(i);
		return p;
	}

	private Point getRandomPrisonerPosition() {
		int i = Functions.rnd(0, prisoner_start_positions.size() - 1);
		Point p = (Point)prisoner_start_positions.get(i);
		prisoner_start_positions.remove(i);
		return p;
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper.side == Client.ATTACKER) {
			Server.IncVPs(Client.DEFENDER, (byte)20);
		}
	}

	public String getOuterWallTexture() {
		return "sand1.png";
	}

	public String getInnerFloorTexture() {
		return "sand2.png";
	}

	public String getDamagedInnerFloorTexture() {
		return "damaged_sand2.png";
	}

	public String getOuterFloorTexture() {
		return "";
	}

	public String getDamagedOuterFloorTexture() {
		return "";
	}

	public String getDamagdeOuterFloorTexture() {
		return "damaged_sand2.png";
	}

	public String getRoadTexture() {
		return "";
	}

	public String getDamagedRoadTexture() {
		return "";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getStarfieldTexture() {
		return "";
	}

	public String getCeilingTexture() {
		return "sand2.png";
	}

	public String getDamagedCeilingTexture() {
		return "damaged_sand2.png";
	}

	public String getLockedDoorTexture() {
		return "door7.png";
	}

	public String getExitTexture() {
		return "bflake.png";
	}

	public void trooperEnteredSquare(SPlayerObject3D trooper, SMapSquare sq) {
		if (sq.getType() == SMapSquare.EXIT) {
			if (trooper instanceof SPlayerObjectPrisoner) {
				Server.IncVPs(trooper.side, (byte)34);
				trooper.remove(false);
			}
		}
	}

	public String getDescription() {
		return "The attackers must rescue the hostages who have been imprisoned in a not-quite-abandoned mine.  The defenders must kill the attackers.  One player note - only the AI for defenders is intelligent.";
	}

	public boolean setupAI(byte side) {
		//    AI
		if (side == Client.DEFENDER) {
			SPlayerObject3D trooper;
			for(int o=0 ; o<Server.objects.length ; o++) {
				if (Server.objects[o] != null) {
					if (Server.objects[o] instanceof SPlayerObject3D) {
						trooper = (SPlayerObject3D) Server.objects[o];
						if (trooper.side == side) {
							if (trooper.isComputerControlled() == false) {
								if (trooper.side == Client.ATTACKER) {
									trooper.setAI(new Wander90AI(trooper));
								} else if (trooper.side == Client.DEFENDER) {
									trooper.setAI(new Wander90AI(trooper));
								}
							}
						}
					}
				}
			}

			return true;
		} else {
			return false;
		}
	}

}
