package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.lang.Functions;
import ssmith.util.CSVString;
import ssmith.astar.WayPoints;
import java.awt.Point;
import java.io.IOException;

import ngrave.ai.DestroyComputersAI;
import ngrave.ai.DestroyComputersAIGroup;
import ngrave.ai.GuardAI;
import ngrave.ai.Wander90AI;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.S2CCommunication;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SBarrel;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectTrooper;

public class MoonbaseAssault extends Mission {

	private byte VPS_PER_ATTACKER_KILLED;
	private static final byte VPS_FOR_DEACT_COMPUTER=5;

	private WayPoints attacker_start_positions = new WayPoints();
	private WayPoints defender_start_positions = new WayPoints();
	private DestroyComputersAIGroup group;

	public boolean randomMap() {
		return true;
	}

	public String getMissionTitle() {
		return "Moonbase Assault";
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public int getMaxTime() {
		return 2000;
	}

	public void timeExpired() {
		Server.IncVPs(Client.DEFENDER, (byte)100);
	}

	public String getMissionBriefing(byte side) {
		switch(side) {
		case 0:
			return "Deactivate as many computers as possible\nYou have "+this.getMaxTime() + " seconds.  You get " + VPS_FOR_DEACT_COMPUTER + " VPs for each computer.";
		case 1:
			return "You must kill all the attackers before they have chance to turn off enough computers, or prevent them from completing their mission for "+this.getMaxTime() + " seconds.";
		default:
			return "";
		}
	}

	public int getCredits(byte side) {
		return 235;
	}

	public boolean wallsCanBeDestroyed() {
		return false;
	}

	public void setupForClient() {
		new CPlanet();
		new CStarfield();
	}


	public void setupForServer() {
		group = new DestroyComputersAIGroup();

		if (Server.game.isRandomMapSelected() == false) {
			TextFile tf = new TextFile();
			try {
				tf.openFile(Client.MISSION_DIR + "moonbaseassault.csv", TextFile.READ);
				CSVString line = new CSVString(tf.readLine());
				byte size = new Byte(line.getFirstSection()).byteValue();
				Server.map = new SMapData(size);
				for (byte z = 0; z < size; z++) {
					line = new CSVString(tf.readLine());
					//System.out.println(line.toString());
					for (byte x = 0; x < size; x++) {
						byte b = new Byte(line.getSection(x)).byteValue();
						if (b == 99) {
							this.defender_start_positions.add(x, z);
							b = SMapSquare.FLOOR;
						} else if (b == 98) {
							this.attacker_start_positions.add(x, z);
							b = SMapSquare.GRASS;
						}
						SMapSquare.MapSquareFactory(Server.map, x, z, b);
						if (b == SMapSquare.DEFENDER_COMPUTER) {
							group.add(x, z);
						}
					}
				}
				tf.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			Server.map = new SMapData((byte)40);
			for (byte z = 0; z < Server.map.size; z++) {
				for (byte x = 0; x < Server.map.size; x++) {
					SMapSquare.MapSquareFactory(Server.map, x, z, SMapSquare.GRASS);
				}
			}

			for (int r=0 ; r<30 ; r++) {
				super.placeRoom();
			}

		    this.attacker_start_positions.add(0, 1);
		    this.attacker_start_positions.add(1, 1);
		    this.attacker_start_positions.add(2, 1);
		    this.attacker_start_positions.add(3, 1);
		    this.attacker_start_positions.add(36, 1);
		    this.attacker_start_positions.add(37, 1);
		    this.attacker_start_positions.add(38, 1);
		    this.attacker_start_positions.add(39, 1);
		    this.attacker_start_positions.add(0, 38);
		    this.attacker_start_positions.add(1, 38);
		    this.attacker_start_positions.add(2, 38);
		    this.attacker_start_positions.add(3, 38);
		    this.attacker_start_positions.add(36, 38);
		    this.attacker_start_positions.add(37, 38);
		    this.attacker_start_positions.add(38, 38);
		    this.attacker_start_positions.add(39, 38);

		    // Place 'puters
			int numComputers = 30;
			while (numComputers > 0) {
				boolean placed = false;
				while (!placed) {
					int x = Functions.rnd(1, Server.map.size-2);
					int z = Functions.rnd(1, Server.map.size-2);
					if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
						if (Server.map.getMapSquare(x-1, z).getType() == SMapSquare.WALL || Server.map.getMapSquare(x+1, z).getType() == SMapSquare.WALL || Server.map.getMapSquare(x, z-1).getType() == SMapSquare.WALL || Server.map.getMapSquare(x, z+1).getType() == SMapSquare.WALL) {
							SMapSquare.MapSquareFactory(Server.map, (byte)x, (byte)z, SMapSquare.DEFENDER_COMPUTER);
							group.add(x, z);
							placed = true;
							numComputers--;
						}
					}
				}
			}

			int DEF_START_POS = 20;

			while (DEF_START_POS > 0) {
				int x = Functions.rnd(5, Server.map.size -5);
				int z = Functions.rnd(5, Server.map.size -5);
				if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
					if (this.defender_start_positions.contains(x, z) == false) { // Check it's not been selected already
						this.defender_start_positions.add(x, z);
						DEF_START_POS--;
					}
				}
			}

		}

		// Place barrels
		int MAX_BARRELS = 10;
		while (MAX_BARRELS > 0) {
			int x = Functions.rnd(5, Server.map.size -5);
			int z = Functions.rnd(5, Server.map.size -5);
			if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
				new SBarrel(x+0.5f, z+0.5f);
				MAX_BARRELS--;
			}
		}

		// Place pictures
		for(int b=0 ; b<10 ; b++) {
			S2CCommunication.SendScenery(S2CCommunication.PICTURE, 0f, 0f, 0);
		}

		int no_of_attackers = 8;
		/*if (ServerFunctions.GetPlayerDataForSide(Client.ATTACKER).isCPU() == true) {
    	no_of_attackers = 12;
    }*/
		VPS_PER_ATTACKER_KILLED = (byte)((101 / no_of_attackers) + 1); 
		// Create troops
		SPlayerObject3D trooper = null;
		for (int q=0 ; q<no_of_attackers ; q++) {
			Point p = this.attacker_start_positions.getRandomPoint(true);
			trooper = new SPlayerObjectTrooper(Client.ATTACKER, p.x + 0.5f, p.y + 0.5f);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

		for (int q=0 ; q<8 ; q++) {
			Point p = this.defender_start_positions.getRandomPoint(true);
			trooper = new SPlayerObjectTrooper(Client.DEFENDER, p.x + 0.5f, p.y + 0.5f);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

	}

	public String getOuterWallTexture() {
		return "bluemetal.png";
	}

	public String getInnerFloorTexture() {
		return "ceilingtiles.png";
	}

	public String getDamagedInnerFloorTexture() {
		return "damaged_ceilingtiles.png";
	}

	public String getOuterFloorTexture() {
		return "moonrock.png";
	}

	public String getDamagedOuterFloorTexture() {
		return "damaged_moonrock.png";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getStarfieldTexture() {
		return "space05.png";
	}

	public String getRoadTexture() {
		return "";
	}

	public String getDamagedRoadTexture() {
		return "";
	}

	public String getCeilingTexture() {
		return "floor15.png";
	}

	public String getDamagedCeilingTexture() {
		return "damaged_floor15.png";
	}

	public String getLockedDoorTexture() {
		return "";
	}

	public String getExitTexture() {
		return "";
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper.side == Client.ATTACKER) {
			Server.IncVPs(Client.DEFENDER, VPS_PER_ATTACKER_KILLED);
		}
	}

	public void computerTurnedOff(byte computer_owner, SMapSquare sq) {
		if (computer_owner == Client.DEFENDER) {
			Server.IncVPs(Client.ATTACKER, VPS_FOR_DEACT_COMPUTER);
		}
	}

	public String getDescription() {
		return "The attackers must Deactivate all the computers on the moonbase.  The defenders must stop them by killing them all.  One player note - The AI for both sides is intelligent.";
	}

	public String getPictureTexture(int no) {
		switch (no) {
		case TexLoader.POSTER1:
			return "pic_ls_ma1.png";
		case TexLoader.POSTER2:
			return "pic_ls_ma2.png";
		case TexLoader.POSTER3:
			return "pic_ls_ma_map.png";
		case TexLoader.POSTER4:
			return "pic_vfest.png";
		default:
			System.err.println("Too high pic no!");
		return "";
		}
	}

	public boolean setupAI(byte side) {
		// AI
		SPlayerObject3D trooper;
		for(int o=0 ; o<Server.objects.length ; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					trooper = (SPlayerObject3D) Server.objects[o];
					if (trooper.side == side) {
						if (trooper.isComputerControlled() == false) {
							if (trooper.side == Client.ATTACKER) {
								trooper.setAI(new DestroyComputersAI(trooper, group));
							} else if (trooper.side == Client.DEFENDER) {
								if (Functions.rnd(0, 1) == 1) {
									trooper.setAI(new Wander90AI(trooper));
								} else {
									trooper.setAI(new GuardAI(trooper));
								}
							}
						}
					}
				}
			}
		}
		return true;
	}

}