package ngrave.missions;

import java.awt.Point;

import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.objects.SPlayerObject3D;
import ssmith.lang.Functions;

public abstract class Mission {

  public abstract String getMissionTitle();

  public abstract String getDescription();

  public abstract String getMissionBriefing(byte side);

  public abstract boolean randomMap();

  public abstract int getCredits(byte side);

  public abstract boolean wallsCanBeDestroyed();

  public abstract void setupForClient();

  public abstract void setupForServer();

  public abstract int getMaxTime();

  public abstract void timeExpired();

  /**
   * Reutn true or false depending on whether it can be done, and do it!
   * @param side
   * @return
   */
  public abstract boolean setupAI(byte side);

  /**
   * Over-ride if reqd.
   */
  public void gameLooped() {

  }

  /**
   * Over-ride if reqd.
   */
  public void computerTurnedOff(byte computer_owner, SMapSquare sq) {

  }

  /**
   * Over-ride if reqd.
   */
  public void trooperEnteredSquare(SPlayerObject3D trooper, SMapSquare sq) {

  }

  public abstract void trooperKilled(SPlayerObject3D trooper) ;

  // Textures
  public abstract String getOuterWallTexture();

  public abstract String getOuterFloorTexture();
  //public abstract String getDamagedOuterFloorTexture();

  public abstract String getInnerFloorTexture();
  //public abstract String getDamagedInnerFloorTexture();

  public abstract String getCeilingTexture();
  //public abstract String getDamagedCeilingTexture();

  public abstract String getRoadTexture();
  //public abstract String getDamagedRoadTexture();

  public abstract String getDoorTexture();

  public abstract String getStarfieldTexture();

  public abstract String getLockedDoorTexture();

  public abstract String getExitTexture();

  public String getPictureTexture(int no) {
  	return "";
  }

  public Point placeRoom(byte x_pos, byte y_pos, byte width, byte length) {
  	for (byte y=y_pos ; y<=y_pos + length ; y++) {
  	  	for (byte x=x_pos ; x<=x_pos + width ; x++) {
  	  		if (y == y_pos || y == y_pos+length || x == x_pos || x == x_pos+width) {
  	  			if (Server.map.getMapSquare(x, y).getType() == SMapSquare.GRASS) {
  	  				SMapSquare.MapSquareFactory(Server.map, x, y, SMapSquare.WALL);
  	  			}
  	  		} else {
  		        SMapSquare.MapSquareFactory(Server.map, x, y, SMapSquare.FLOOR);
  	  		}
  	  	}
  	}

  	int doors = Functions.rnd(1, 2);
  	for (int d=0 ; d<doors ; d++) {
  		byte door_x = 0;
  		byte door_y = 0;
  		if (Functions.rnd(0, 1) == 0) {
  			door_x = (byte)(x_pos +(Functions.rnd(0, 1) * width));
  			door_y = (byte)(y_pos + (byte)Functions.rnd(1, length-2));
  		} else {
  			door_x = (byte)(x_pos + (byte)Functions.rnd(1, width-2));
  			door_y = (byte)(y_pos +(Functions.rnd(0, 1) * length));
  		}
		if (Server.map.getMapSquare(door_x, door_y).getType() == SMapSquare.WALL) {
  				SMapSquare.MapSquareFactory(Server.map, door_x, door_y, SMapSquare.CLOSED_DOOR);
		}

  	}
  	return new Point(x_pos + (width/2), y_pos + (length/2));

  }

  public Point placeRoom() {
  	byte width = (byte) Functions.rnd(3, 6);
  	byte length = (byte) Functions.rnd(3, 8);
  	byte x_pos = (byte) Functions.rnd(2, Server.map.size - width - 5);
  	byte y_pos = (byte) Functions.rnd(2, Server.map.size - length - 5);

  	return placeRoom(x_pos, y_pos, width, length);
  }

}

