package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.util.*;
import java.io.IOException;
import ngrave.ai.DestroyComputersAI;
import ngrave.ai.DestroyComputersAIGroup;
import ngrave.client.Client;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectTrooper;


/**
 * This is the one WITH a computer to turn off.
 */
public class GuerillaWar  { //todo - make proper mission

	// todo - change these to WayPoints
	//protected ArrayList defender_start_positions = new ArrayList();

	  public String getMissionTitle() {
	  	return "Guerilla Warfare";
	  }
	  
	  public boolean randomMap() {
	  	return false;
	  }

	  public String getMissionBriefing(byte side) {
	    return "Turn off the enemy's computer!";
	  }

	  public void setupForServer() throws IOException {
	  	DestroyComputersAIGroup att_group = new DestroyComputersAIGroup();
	  	DestroyComputersAIGroup def_group = new DestroyComputersAIGroup();
	  	
	  	TextFile tf = new TextFile();
	  	tf.openFile(Client.MISSION_DIR + "guerillawar.csv", TextFile.READ);
	  	CSVString line = new CSVString(tf.readLine());
	  	byte size = new Byte(line.getFirstSection()).byteValue();
	  	Server.map = new SMapData(size);
	  	for (byte z = 0; z < size; z++) {
	  		line = new CSVString(tf.readLine());
	  		//System.out.println(line.toString());
	  		for (byte x = 0; x < size; x++) {
	  			byte b = new Byte(line.getSection(x)).byteValue();
	  			if (b == 99) {
	  				//this.defender_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
	  				b = SMapSquare.GRASS;
	  			}
	  			SMapSquare.MapSquareFactory(Server.map, x, z, b);
	  			if (b == SMapSquare.DEFENDER_COMPUTER) {
	  				att_group.add(x, z);
	  			} else if (b == SMapSquare.ATTACKER_COMPUTER) {
	  				def_group.add(x, z);
	  			}
	  		}
	  	}
	  	tf.close();
	  	
	  	// Create troops
	  	SPlayerObject3D trooper;
	  	trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 1f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 2f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 3f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 4f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 5f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 6f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	
	  	trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 34f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 35f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 36f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 37f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 38f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 39f);
	  	//if (Server.default_equipment || trooper.computer_controlled) {
	  		if (trooper.hasAnyItems() == false) {
	  			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
	  			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
	  			trooper.setArmour(18);
	  		}
	  	//}
	  	
	  	// AI
	  	for(int o=0 ; o<Server.objects.length ; o++) {
	  		if (Server.objects[o] != null) {
	  			if (Server.objects[o] instanceof SPlayerObject3D) {
	  				trooper = (SPlayerObject3D) Server.objects[o];
	  					if (trooper.side == Client.ATTACKER) {
	  						trooper.setAI(new DestroyComputersAI(trooper, att_group));
	  					} else if (trooper.side == Client.DEFENDER) {
	  						trooper.setAI(new DestroyComputersAI(trooper, def_group));
	  					}
	  			}
	  		}
	  	}
	  }

  public void computerTurnedOff(byte computer_owner, SMapSquare sq) throws IOException {
  	if (computer_owner == Client.ATTACKER) {
  		Server.IncVPs(Client.DEFENDER, (byte)100);
  	} else if (computer_owner == Client.DEFENDER) {
  		Server.IncVPs(Client.ATTACKER, (byte)100);
 		
  	}
  }
  
	public String getDescription() {
		return "Two sides battle it out to destroy each others computer.  One-player note - both side have AI.";
	}

}
