package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.lang.Functions;
import ssmith.util.CSVString;
import ssmith.awt.PointF;
import java.io.IOException;
import java.util.ArrayList;
import ngrave.ai.Wander90AI;
import ngrave.client.Client;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SBarrel;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectTrooper;

public class Fortress
extends Mission {

	// todo - change these to WayPoints
	private ArrayList attacker_start_positions = new ArrayList();
	private ArrayList defender_start_positions = new ArrayList();

	public String getMissionTitle() {
		return "Fortress";
	}

	public boolean randomMap() {
		return false;
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public int getMaxTime() {
		return -1;
	}

	public void timeExpired() {
	}

	public String getMissionBriefing(byte side) {
		switch(side) {
		case 0:
			return "You must turn off the fortress computer.";
		case 1:
			return "You must kill all the attackers before they can turn off the fortress computer.";
		default:
			return "";
		}
	}

	public int getCredits(byte side) {
		return 235;
	}

	public boolean wallsCanBeDestroyed() {
		return true;
	}

	public void setupForClient() {
		new CPlanet();
		new CPlanet();
		new CStarfield();
	}


	public void setupForServer() {
		TextFile tf = new TextFile();
		try {
			tf.openFile(Client.MISSION_DIR + "fortress.csv", TextFile.READ);
			CSVString line = new CSVString(tf.readLine());
			byte size = new Byte(line.getFirstSection()).byteValue();
			Server.map = new SMapData(size);
			for (byte z = 0; z < size; z++) {
				line = new CSVString(tf.readLine());
				//System.out.println(line.toString());
				for (byte x = 0; x < size; x++) {
					byte b = new Byte(line.getSection(x)).byteValue();
					if (b == 99) {
						this.defender_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
						b = SMapSquare.FLOOR;
					}
					else if (b == 98) {
						this.attacker_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
						b = SMapSquare.GRASS;
					}
					SMapSquare.MapSquareFactory(Server.map, x, z, b);
				}
			}
			tf.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		// Place barrels
		int MAX_BARRELS = 15;
		while (MAX_BARRELS > 0) {
			int x = Functions.rnd(5, Server.map.size -5);
			int z = Functions.rnd(5, Server.map.size -5);
			if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
				new SBarrel(x+0.5f, z+0.5f);
				MAX_BARRELS--;
			}
		}

		// Create troops
		SPlayerObject3D trooper;
		for (int q=0 ; q<8 ; q++) {
			PointF p = this.getRandomAttackerPosition();
			trooper = new SPlayerObjectTrooper(Client.ATTACKER,
					p.x, p.y);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

		for (int q=0 ; q<8 ; q++) {
			PointF p = this.getRandomDefenderPosition();
			trooper = new SPlayerObjectTrooper(Client.DEFENDER,
					p.x, p.y);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

		// AI
		for(int o=0 ; o<Server.objects.length ; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					trooper = (SPlayerObject3D) Server.objects[o];
					//if (trooper.computer_controlled) {
					if (trooper.side == Client.ATTACKER) {
						trooper.setAI(new Wander90AI(trooper));
					} else if (trooper.side == Client.DEFENDER) {
						trooper.setAI(new Wander90AI(trooper));
					}
					//}
				}
			}
		}
	}

	private PointF getRandomAttackerPosition() {
		int i = Functions.rnd(0, attacker_start_positions.size() - 1);
		PointF p = (PointF) attacker_start_positions.get(i);
		attacker_start_positions.remove(i);
		return p;
	}

	private PointF getRandomDefenderPosition() {
		int i = Functions.rnd(0, defender_start_positions.size() - 1);
		PointF p = (PointF) defender_start_positions.get(i);
		defender_start_positions.remove(i);
		return p;
	}

	public String getOuterWallTexture() {
		return "bluemetal.png";
	}

	public String getInnerFloorTexture() {
		return "floor15.png";
	}

	public String getDamagedInnerFloorTexture() {
		return "damaged_floor15.png";
	}

	public String getOuterFloorTexture() {
		return "moonrock.png";
	}

	public String getDamagedOuterFloorTexture() {
		return "damaged_moonrock.png";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getStarfieldTexture() {
		return "space05.png";
	}

	public String getRoadTexture() {
		return "";
	}

	public String getDamagedRoadTexture() {
		return "";
	}

	public String getCeilingTexture() {
		return "floor15.png";
	}

	public String getDamagedCeilingTexture() {
		return "damaged_floor15.png";
	}

	public String getLockedDoorTexture() {
		return "";
	}

	public String getExitTexture() {
		return "";
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper.side == Client.ATTACKER) {
			Server.IncVPs(Client.DEFENDER, (byte)13);
		}
	}

	public void computerTurnedOff(byte computer_owner, SMapSquare sq) {
		if (computer_owner == Client.DEFENDER) {
			Server.IncVPs(Client.ATTACKER, (byte)100);
		}
	}

	public String getDescription() {
		return "** This mission is still under development**  ";
	}

	public boolean setupAI(byte side) {
		// TODO Auto-generated method stub
		return false;
	}

}