package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.lang.Functions;
import ssmith.util.CSVString;
import ssmith.astar.WayPoints;
import java.awt.Point;
import java.io.IOException;

import ngrave.ai.EscortAI;
import ngrave.ai.EscortGroupAI;
import ngrave.ai.GoToAI;
import ngrave.ai.HuntForAI;
import ngrave.ai.HuntForAIGroup;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.S2CCommunication;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectRobot;
import ngrave.server.objects.SPlayerObjectSternerRegnix;
import ngrave.server.objects.SPlayerObjectTrooper;

public class EscapeFromTheMoonbase
extends Mission {

	private WayPoints attacker_start_positions = new WayPoints();
	private WayPoints defender_start_positions = new WayPoints();
	private WayPoints look_in_locations = new WayPoints();
	private WayPoints escape_locations = new WayPoints();
	private SPlayerObjectSternerRegnix sterner;

	public boolean randomMap() {
		return true;
	}

	public String getMissionTitle() {
		return "Escape from the Moonbase";
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public int getMaxTime() {
		return 2000;
	}

	public void timeExpired() {
		Server.IncVPs(Client.ATTACKER, (byte)100);
	}

	public String getMissionBriefing(byte side) {
		switch(side) {
		case 0:
			return "You must kill Sterner Regnix and make sure he doesn't escape.  He has "+this.getMaxTime() + " seconds to escape.";
		case 1:
			return "You must get Sterner Regnix off the moonbase via one of the teleports situated around the edges of the map.  He has "+this.getMaxTime() + " seconds to escape.";
		default:
			return "Error";
		}
	}

	public int getCredits(byte side) {
		return 235;
	}

	public boolean wallsCanBeDestroyed() {
		return true;
	}

	public void setupForClient() {
		new CPlanet();
		new CStarfield();
	}


	public void setupForServer() {
		look_in_locations = new WayPoints();
		escape_locations = new WayPoints();

		if (Server.game.isRandomMapSelected() == false) {
			TextFile tf = new TextFile();
			try {
				tf.openFile(Client.MISSION_DIR + "escapefromthemoonbase.csv", TextFile.READ);
				CSVString line = new CSVString(tf.readLine());
				byte size = new Byte(line.getFirstSection()).byteValue();
				Server.map = new SMapData(size);
				for (byte z = 0; z < size; z++) {
					line = new CSVString(tf.readLine());
					//System.out.println(line.toString());
					for (byte x = 0; x < size; x++) {
						byte b = new Byte(line.getSection(x)).byteValue();
						if (b == 99) {
							this.defender_start_positions.add(x, z);
							b = SMapSquare.FLOOR;
							look_in_locations.add(x, z);
						} else if (b == 98) {
							this.attacker_start_positions.add(x, z);
							b = SMapSquare.GRASS;
						}
						SMapSquare.MapSquareFactory(Server.map, x, z, b);
						if (b == SMapSquare.EXIT) {
							escape_locations.add(x, z);
						}
					}
				}
				tf.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			Server.map = new SMapData((byte)40);
			for (byte z = 0; z < Server.map.size; z++) {
				for (byte x = 0; x < Server.map.size; x++) {
					SMapSquare.MapSquareFactory(Server.map, x, z, SMapSquare.GRASS);
				}
			}
			super.placeRoom((byte)16, (byte)18, (byte)8, (byte)5);

			for (int r=0 ; r<30 ; r++) {
				Point p = super.placeRoom();
				look_in_locations.add(p);
			}


		    SMapSquare.MapSquareFactory(Server.map, (byte)0, (byte)0, SMapSquare.EXIT);
			escape_locations.add(0, 0);
			SMapSquare.MapSquareFactory(Server.map, (byte)39, (byte)0, SMapSquare.EXIT);
			escape_locations.add(39, 0);
			SMapSquare.MapSquareFactory(Server.map, (byte)0, (byte)39, SMapSquare.EXIT);
			escape_locations.add(0, 39);
			SMapSquare.MapSquareFactory(Server.map, (byte)39, (byte)39, SMapSquare.EXIT);
			escape_locations.add(39, 39);

		    this.attacker_start_positions.add(0, 1);
		    this.attacker_start_positions.add(1, 1);
		    this.attacker_start_positions.add(2, 1);
		    this.attacker_start_positions.add(3, 1);
		    this.attacker_start_positions.add(36, 1);
		    this.attacker_start_positions.add(37, 1);
		    this.attacker_start_positions.add(38, 1);
		    this.attacker_start_positions.add(39, 1);
		    this.attacker_start_positions.add(0, 38);
		    this.attacker_start_positions.add(1, 38);
		    this.attacker_start_positions.add(2, 38);
		    this.attacker_start_positions.add(3, 38);
		    this.attacker_start_positions.add(36, 38);
		    this.attacker_start_positions.add(37, 38);
		    this.attacker_start_positions.add(38, 38);
		    this.attacker_start_positions.add(39, 38);

		    this.defender_start_positions.add(18, 20);
		    this.defender_start_positions.add(19, 20);
		    this.defender_start_positions.add(20, 20);
		    this.defender_start_positions.add(21, 20);
		    this.defender_start_positions.add(18, 21);
		    this.defender_start_positions.add(19, 21);
		    this.defender_start_positions.add(20, 21);
		    this.defender_start_positions.add(21, 21);
		    this.defender_start_positions.add(22, 21);
		}

		// Place pictures
		for(int b=0 ; b<10 ; b++) {
			S2CCommunication.SendScenery(S2CCommunication.PICTURE, 0f, 0f, 0);
		}

		int no_of_attackers = 8;

		// Create troops
		SPlayerObject3D trooper;
		for (int q=0 ; q<no_of_attackers ; q++) {
			Point p = this.attacker_start_positions.getRandomPoint(true);
			//this.attacker_start_positions.remove(p);
			trooper = new SPlayerObjectTrooper(Client.ATTACKER, p.x + 0.5f, p.y + 0.5f);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.setArmour(18);
			}
			//}
		}

		for (int q=0 ; q<5 ; q++) {
			Point p = this.defender_start_positions.getRandomPoint(true);
			new SPlayerObjectRobot(Client.DEFENDER, p.x + 0.5f, p.y + 0.5f);
		}
		Point p = this.defender_start_positions.getRandomPoint();
		this.defender_start_positions.remove(p);
		sterner = new SPlayerObjectSternerRegnix(Client.DEFENDER, p.x + 0.5f, p.y + 0.5f);

	}

	public String getOuterWallTexture() {
		return "bluemetal.png";
	}

	public String getInnerFloorTexture() {
		return "floor15.png";
	}

	public String getDamagedInnerFloorTexture() {
		return "damaged_floor15.png";
	}

	public String getOuterFloorTexture() {
		return "moonrock.png";
	}

	public String getDamagedOuterFloorTexture() {
		return "damaged_moonrock.png";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getStarfieldTexture() {
		return "space05.png";
	}

	public String getRoadTexture() {
		return "";
	}

	public String getDamagedRoadTexture() {
		return "";
	}

	public String getCeilingTexture() {
		return "floor15.png";
	}

	public String getDamagedCeilingTexture() {
		return "damaged_floor15.png";
	}

	public String getLockedDoorTexture() {
		return "";
	}

	public String getExitTexture() {
		return "bflake.png";
	}

	public void trooperEnteredSquare(SPlayerObject3D trooper, SMapSquare sq) {
		if (sq.getType() == SMapSquare.EXIT) {
			if (trooper.side == Client.DEFENDER) {
				if (trooper instanceof SPlayerObjectSternerRegnix) {
					Server.IncVPs(Client.DEFENDER, (byte)100);
				}
				trooper.remove(false); // Stop them blocking the exit.
			}
		}
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper.side == Client.DEFENDER) {
			if (trooper instanceof SPlayerObjectSternerRegnix) {
				Server.IncVPs(Client.ATTACKER, (byte)100);
			}
		}
	}

	public void computerTurnedOff(byte computer_owner, SMapSquare sq) {
	}

	public String getDescription() {
		return "The attackers must kill Sterner Regnix.  The defenders must escort him off the moonbase. One-player note - both sides have intelligent AI.";
	}

	public String getPictureTexture(int no) {
		switch (no) {
		case TexLoader.POSTER1:
			return "pic_ls_ma1.png";
		case TexLoader.POSTER2:
			return "pic_ls_ma2.png";
		case TexLoader.POSTER3:
			return "pic_ls_ma_map.png";
		case TexLoader.POSTER4:
			return "pic_vfest.png";
		default:
			System.err.println("Too high pic no!");
		return "";
		}
	}

	public boolean setupAI(byte side) {
		// AI
		EscortGroupAI escortgroup = new EscortGroupAI(sterner, escape_locations);
		HuntForAIGroup huntgroup = new HuntForAIGroup(sterner, look_in_locations);

		SPlayerObject3D trooper;
		for(int o=0 ; o<Server.objects.length ; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					trooper = (SPlayerObject3D) Server.objects[o];
					if (trooper.side == side) {
						if (trooper.isComputerControlled() == false) {
							if (trooper.side == Client.ATTACKER) {
								trooper.setAI(new HuntForAI(trooper, huntgroup));
							} else if (trooper.side == Client.DEFENDER) {
								if (trooper instanceof SPlayerObjectSternerRegnix || escortgroup.getNoOfBodyguards() < 3 || Functions.rnd(0,2) == 0) {
									trooper.setAI(new EscortAI(trooper, escortgroup));
								} else {
									trooper.setAI(new GoToAI(trooper, escape_locations.getRandomPoint()));
								}
							}
						}
					}
				}
			}
		}
		return true;
	}

}
