package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.awt.PointF;
import ssmith.lang.Functions;
import ssmith.util.CSVString;
import java.io.IOException;
import java.util.ArrayList;

import ngrave.ai.DestroyComputersAI;
import ngrave.ai.DestroyComputersAIGroup;
import ngrave.client.Client;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SBarrel;
import ngrave.server.objects.SCrate;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectTrooper;

public class DestroyTheBase
    extends Mission {

	// todo - change these to WayPoints
	private ArrayList attacker_start_positions = new ArrayList();
	private ArrayList defender_start_positions = new ArrayList();

  public String getMissionTitle() {
  	return "Destroy the Base";
  }
  
  public boolean randomMap() {
  	return false;
  }

  public int getNoOfPlayers() {
  	return 2;
  }

  public int getMaxTime() {
  	return -1;
  }

  public void timeExpired() {
  	// Do nothing
  }
  
  public String getMissionBriefing(byte side) {
  	return "Deactivate the enemy's computer.";
  }

  public int getCredits(byte side) {
  		return 200;
  }

  public boolean wallsCanBeDestroyed() {
  	return true;
  }

  public void setupForClient() {
    new CPlanet();
    new CStarfield();
  }

  public void setupForServer() {
    DestroyComputersAIGroup att_group = new DestroyComputersAIGroup();
    DestroyComputersAIGroup def_group = new DestroyComputersAIGroup();

    TextFile tf = new TextFile();
    try {
        tf.openFile(Client.MISSION_DIR + "destroythebase.csv", TextFile.READ);
        CSVString line = new CSVString(tf.readLine());
        byte size = new Byte(line.getFirstSection()).byteValue();
        Server.map = new SMapData(size);
        for (byte z = 0; z < size; z++) {
          line = new CSVString(tf.readLine());
          //System.out.println(line.toString());
          for (byte x = 0; x < size; x++) {
            byte b = new Byte(line.getSection(x)).byteValue();
            if (b == 99) {
              this.defender_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
              b = SMapSquare.FLOOR;
            }
            else if (b == 98) {
              this.attacker_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
              b = SMapSquare.FLOOR;
            }
            SMapSquare.MapSquareFactory(Server.map, x, z, b);
            if (b == SMapSquare.DEFENDER_COMPUTER) {
            	att_group.add(x, z);
            } else if (b == SMapSquare.ATTACKER_COMPUTER) {
            	def_group.add(x, z);
            }
          }
        }
        tf.close();
    } catch (IOException e) {
        e.printStackTrace();
    }

    // Place barrels
    int barrels = 3;
    while (barrels > 0) {
      int x = Functions.rnd(5, Server.map.size -5);
      int z = Functions.rnd(5, Server.map.size -5);
      if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
        new SBarrel(x+0.5f, z+0.5f);
        barrels--;
      }
    }

    // Place crates
    barrels = 3;
    while (barrels > 0) {
      int x = Functions.rnd(5, Server.map.size -5);
      int z = Functions.rnd(5, Server.map.size -5);
      if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
        new SCrate(x+0.5f, z+0.5f);
        barrels--;
      }
    }

    // Create troops
    SPlayerObject3D trooper;
    for(int q=0 ; q<5 ; q++) {
    	PointF p = this.getRandomAttackerPosition();
    	trooper = new SPlayerObjectTrooper(Client.ATTACKER, p.x, p.y);
    	//if (Server.default_equipment || trooper.computer_controlled) {
    		if (trooper.hasAnyItems() == false) {
    			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
    			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
    			trooper.setArmour(18);
    		}
    	//}
    }
    
    for(int q=0 ; q<5 ; q++) {
    	PointF p = this.getRandomDefenderPosition();
    	trooper = new SPlayerObjectTrooper(Client.DEFENDER, p.x, p.y);
    	//if (Server.default_equipment || trooper.computer_controlled) {
    		if (trooper.hasAnyItems() == false) {
    			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
    			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
    			trooper.setArmour(18);
    		}
    	//}
    }
    
    // AI
    for(int o=0 ; o<Server.objects.length ; o++) {
    	if (Server.objects[o] != null) {
    		if (Server.objects[o] instanceof SPlayerObject3D) {
    			trooper = (SPlayerObject3D) Server.objects[o];
    			//if (trooper.computer_controlled) {
    				if (trooper.side == Client.ATTACKER) {
    					trooper.setAI(new DestroyComputersAI(trooper, att_group));
    				} else if (trooper.side == Client.DEFENDER) {
    					trooper.setAI(new DestroyComputersAI(trooper, def_group));
    				}
    			//}
    		}
    	}
    }

  }

  private PointF getRandomAttackerPosition() {
    int i = Functions.rnd(0, attacker_start_positions.size() - 1);
    PointF p = (PointF) attacker_start_positions.get(i);
    attacker_start_positions.remove(i);
    return p;
  }

  private PointF getRandomDefenderPosition() {
    int i = Functions.rnd(0, defender_start_positions.size() - 1);
    PointF p = (PointF) defender_start_positions.get(i);
    defender_start_positions.remove(i);
    return p;
  }

  public void computerTurnedOff(byte computer_owner, SMapSquare sq) {
  	if (computer_owner == Client.DEFENDER) {
 		Server.IncVPs(Client.ATTACKER, (byte)100);
  	} else if (computer_owner == Client.ATTACKER) {
 		Server.IncVPs(Client.DEFENDER, (byte)100);
  	}
  }

  public void gameLooped() {
  }

  public String getOuterWallTexture() {
    return "metal5.png";
  }

  public String getInnerFloorTexture() {
    return "floor02.png";
  }

  public String getDamagedInnerFloorTexture() {
    return "damaged_floor02.png";
  }

  public String getOuterFloorTexture() {
    return "grass.png";
  }

  public String getDamagedOuterFloorTexture() {
    return "damaged_grass.png";
  }

  public String getRoadTexture() {
    return "road1.png";
  }

  public String getDamagedRoadTexture() {
    return "damaged_road1.png";
  }

  public String getDoorTexture() {
    return "door11.png";
  }

  public String getStarfieldTexture() {
    return "mineral5.png";
  }

  public String getCeilingTexture() {
    return "beige012.png";
  }

  public String getDamagedCeilingTexture() {
    return "damaged_beige012.png";
  }

  public String getLockedDoorTexture() {
    return "";
  }

  public String getExitTexture() {
    return "";
  }

  public void trooperKilled(SPlayerObject3D trooper) {
  }

	public String getDescription() {
		return "Both sides must Deactivate the other sides computer.  One-player note: both sides have intelligent AI.";
	}

    public boolean setupAI(byte side) {
        // TODO Auto-generated method stub
        return false;
    }

}
