package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.util.*;
import ssmith.lang.Functions;
import ssmith.awt.PointF;
import java.io.*;
import java.util.ArrayList;

import ngrave.ai.AlienAI;
import ngrave.ai.Wander90AI;
import ngrave.client.Client;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectAlien;
import ngrave.server.objects.SPlayerObjectTrooper;

public class Deathwing
extends Mission {

	// todo - change these to WayPoints
	private ArrayList alien_start_positions = new ArrayList();

	public String getMissionTitle() {
		return "Deathwing";
	}

	public boolean randomMap() {
		return false;
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public int getMaxTime() {
		return 2000;
	}

	public void timeExpired() {
		Server.IncVPs(Client.DEFENDER, (byte)100);
	}

	public String getMissionBriefing(byte side) {
		switch(side) {
		case 0:
			return "This mission is still being developed.\n\nYou must get at least two troopers to the exit hatch on the other side of the ship within "+this.getMaxTime() + " seconds.";
		case 1:
			return "This mission is still being developed.\n\nYou must kill at least 3 troopers before they manage to escape.";
		default:
			return "";
		}
	}

	public int getCredits(byte side) {
		switch (side) {
		case 0:
			return 235;
		default:
			return 0;
		}
	}

	public boolean wallsCanBeDestroyed() {
		return false;
	}

	public void setupForClient() {
		new CPlanet();
		new CStarfield();
	}

	public void setupForServer() {
		TextFile tf = new TextFile();
		try {
			tf.openFile(Client.MISSION_DIR + "deathwing.csv", TextFile.READ);
			CSVString line = new CSVString(tf.readLine());
			byte size = new Byte(line.getFirstSection()).byteValue();
			Server.map = new SMapData(size);
			for (byte z = 0; z < size; z++) {
				line = new CSVString(tf.readLine());
				//System.out.println(line.toString());
				for (byte x = 0; x < size; x++) {
					byte b = new Byte(line.getSection(x)).byteValue();
					if (b == 99) {
						this.alien_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
						b = SMapSquare.FLOOR;
					}
					SMapSquare.MapSquareFactory(Server.map, x, z, b);
				}
			}
			tf.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		// Create troops
		SPlayerObject3D trooper;
		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 2.5f, 2.5f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 2.5f, 3.5f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 3.5f, 2.5f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 3.5f, 3.5f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		for (int a=0 ; a<8 ; a++) {
			PointF p = this.getRandomAlienPosition();
			new SPlayerObjectAlien(Client.DEFENDER, p.x, p.y);
		}

	}

	private PointF getRandomAlienPosition() {
		int i = Functions.rnd(0, alien_start_positions.size() - 1);
		PointF p = (PointF) alien_start_positions.get(i);
		alien_start_positions.remove(i);
		return p;
	}

	public String getOuterWallTexture() {
		return "marble.png";
	}

	public String getInnerFloorTexture() {
		return "marble.png";
	}

	public String getDamagedInnerFloorTexture() {
		return "marble.png";
	}

	public String getOuterFloorTexture() {
		return "";
	}

	public String getDamagedOuterFloorTexture() {
		return "";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getStarfieldTexture() {
		return "mineral5.png";
	}

	public String getCeilingTexture() {
		return "marble.png";
	}

	public String getDamagedCeilingTexture() {
		return "marble.png";
	}

	public String getRoadTexture() {
		return "";
	}

	public String getDamagedRoadTexture() {
		return "";
	}

	public String getLockedDoorTexture() {
		return "";
	}

	public String getExitTexture() {
		return "bflake.png";
	}

	public void trooperEnteredSquare(SPlayerObject3D trooper, SMapSquare sq) {
		if (sq.getType() == SMapSquare.EXIT) {
			if (trooper.side == Client.ATTACKER) {
				Server.IncVPs(trooper.side, (byte)50);
				trooper.remove(false);
			}
		}
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper.side == Client.ATTACKER) {
			Server.IncVPs(Client.DEFENDER, (byte)34);
		}
	}

	public String getDescription() {
		return "The troopers must get to the exit, and the aliens must stop them.  One player note - only the AI for defenders is intelligent.";
	}

	public boolean setupAI(byte side) {
		// AI
		SPlayerObject3D trooper;

		for(int o=0 ; o<Server.objects.length ; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					trooper = (SPlayerObject3D) Server.objects[o];
					if (trooper.side == side) {
						if (trooper.isComputerControlled() == false) {
							if (trooper.side == Client.ATTACKER) {
								trooper.setAI(new Wander90AI(trooper));
							} else if (trooper.side == Client.DEFENDER) {
								trooper.setAI(new AlienAI(trooper));
							}
						}
					}
				}
			}
		}
		return true;
	}

}
