package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.util.*;
import ssmith.lang.Functions;
import ssmith.awt.PointF;
import java.io.*;
import java.util.ArrayList;

import ngrave.ai.AttackSquadAI;
import ngrave.ai.AttackSquadAIGroup;
import ngrave.client.Client;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectTrooper;

public class BattleInTheJungle
extends Mission {

	// todo - change these to WayPoints
	private ArrayList attacker_start_positions = new ArrayList();
	private ArrayList defender_start_positions = new ArrayList();

	private int start_attackers = 5, start_defenders=5;

	public String getMissionTitle() {
		return "Battle in the Jungle";
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public boolean randomMap() {
		return false;
	}

	public int getMaxTime() {
		return -1;
	}

	public void timeExpired() {
		// Do nothing
	}

	public String getMissionBriefing(byte side) {
		return "Hunt down the enemy in the jungle and kill them.";
	}

	public int getCredits(byte side) {
		return 240;
	}


	public boolean wallsCanBeDestroyed() {
		return true;
	}

	public void setupForClient() {
		new CPlanet();
		new CPlanet();
		new CPlanet();
		new CStarfield();
	}


	public void setupForServer() {
		TextFile tf = new TextFile();
		try {
			tf.openFile(Client.MISSION_DIR + "battleinthejungle.csv", TextFile.READ);
			CSVString line = new CSVString(tf.readLine());
			byte size = new Byte(line.getFirstSection()).byteValue();
			Server.map = new SMapData(size);
			for (byte z = 0; z < size; z++) {
				line = new CSVString(tf.readLine());
				//System.out.println(line.toString());
				for (byte x = 0; x < size; x++) {
					byte b = new Byte(line.getSection(x)).byteValue();
					if (b == 99) {
						this.defender_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
						b = SMapSquare.GRASS;
					}
					else if (b == 98) {
						this.attacker_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
						b = SMapSquare.GRASS;
					}
					SMapSquare.MapSquareFactory(Server.map, x, z, b);
				}
			}
			tf.close();
		} catch (IOException e) {
			Server.HandleError(e);
		}

		// Place trees
		int MAX_TREES = 100;
		for(int b=0 ; b<MAX_TREES ; b++) {
			byte x = (byte)Functions.rnd(5, Server.map.size -5);
			byte z = (byte)Functions.rnd(0, Server.map.size - 1);
			SMapSquare.MapSquareFactory(Server.map, x, z, SMapSquare.TREE);
		}

		// Place buildings
		int MAX_BUILDINGS = 3;
		for(int b=0 ; b<MAX_BUILDINGS ; b++) {
			byte x = (byte)Functions.rnd(5, Server.map.size -5);
			byte z = (byte)Functions.rnd(2, Server.map.size - 2);
			SMapSquare.MapSquareFactory(Server.map, x, z, SMapSquare.WALL);
		}

		// Create troops
		SPlayerObject3D trooper;
		/*if (ServerFunctions.GetPlayerDataForSide(Client.ATTACKER).isCPU()) {
    	start_attackers = 7;
    }*/
		for (int q=0 ; q<start_attackers ; q++) {
			PointF p = this.getRandomAttackerPosition();
			trooper = new SPlayerObjectTrooper(Client.ATTACKER, p.x, p.y);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

		/*if (ServerFunctions.GetPlayerDataForSide(Client.DEFENDER).isCPU()) {
    	start_defenders = 7;
    	}*/
		// Defenders
		for (int q=0 ; q<start_defenders ; q++) {
			PointF p = this.getRandomDefenderPosition();
			trooper = new SPlayerObjectTrooper(Client.DEFENDER, p.x, p.y);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

	}

	private PointF getRandomAttackerPosition() {
		int i = Functions.rnd(0, attacker_start_positions.size() - 1);
		PointF p = (PointF) attacker_start_positions.get(i);
		attacker_start_positions.remove(i);
		return p;
	}

	private PointF getRandomDefenderPosition() {
		int i = Functions.rnd(0, defender_start_positions.size() - 1);
		PointF p = (PointF) defender_start_positions.get(i);
		defender_start_positions.remove(i);
		return p;
	}

	public void gameLooped() {
	}

	public String getOuterWallTexture() {
		return "brick2.png";
	}

	public String getInnerFloorTexture() {
		return "";
	}

	public String getDamagedInnerFloorTexture() {
		return "";
	}

	public String getOuterFloorTexture() {
		return "grass.png";
	}

	public String getDamagedOuterFloorTexture() {
		return "damaged_grass.png";
	}

	public String getRoadTexture() {
		return "road1.png";
	}

	public String getDamagedRoadTexture() {
		return "damaged_road1.png";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getStarfieldTexture() {
		return "space05.png";
	}

	public String getCeilingTexture() {
		return "";
	}

	public String getDamagedCeilingTexture() {
		return "";
	}

	public String getLockedDoorTexture() {
		return "";
	}

	public String getExitTexture() {
		return "";
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper.side == Client.ATTACKER) {
			Server.IncVPs(Client.DEFENDER, (byte)(101/start_attackers));
		} else if (trooper.side == Client.DEFENDER) {
			Server.IncVPs(Client.ATTACKER, (byte)(101/start_defenders));
		}
	}

	public String getDescription() {
		return "Both sides battle it out in a jungle.  One-player note - both sides have AI.";
	}

	public boolean setupAI(byte side) {
		// AI
		AttackSquadAIGroup att_grp = new AttackSquadAIGroup();
		AttackSquadAIGroup def_grp = new AttackSquadAIGroup();

		SPlayerObject3D trooper;
		for(int o=0 ; o<Server.objects.length ; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					trooper = (SPlayerObject3D) Server.objects[o];
					if (trooper.side == side) {
						if (trooper.isComputerControlled() == false) {
							if (trooper.side == Client.ATTACKER) {
								trooper.setAI(new AttackSquadAI(trooper, att_grp));
							} else if (trooper.side == Client.DEFENDER) {
								trooper.setAI(new AttackSquadAI(trooper, def_grp));
							}
						}
					}
				}
			}
		}
		return true;
	}

}
