package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.util.*;
import java.io.IOException;
import ngrave.ai.AttackSquadAI;
import ngrave.ai.AttackSquadAIGroup;
import ngrave.client.Client;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectTrooper;

/**
 * This is the street battle.
 */
public class Baghdad3000
extends Mission {

	// todo - change these to WayPoints
	//protected ArrayList defender_start_positions = new ArrayList();

	public String getMissionTitle() {
		return "Baghdad 3000";
	}

	public boolean randomMap() {
		return false;
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public int getMaxTime() {
		return -1;
	}

	public void timeExpired() {
		// Do nothing
	}

	public String getMissionBriefing(byte side) {
		return "Kill the enemy!";
	}

	public int getCredits(byte side) {
		return 235;
	}

	public boolean wallsCanBeDestroyed() {
		return false;
	}

	public void setupForClient() {
		new CPlanet();
		new CStarfield();
	}

	public void setupForServer() {
		loadMap();
		// Create troops
		SPlayerObject3D trooper;

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 1f);
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 2f);
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 3f);
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 4f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 5f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.ATTACKER, 1f, 6f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}


		trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 34f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 35f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 36f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 37f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 38f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

		trooper = new SPlayerObjectTrooper(Client.DEFENDER, 38f, 39f);
		//if (Server.default_equipment || trooper.computer_controlled) {
		if (trooper.hasAnyItems() == false) {
			trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
			trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
			trooper.setArmour(18);
		}
		//}

	}

	protected void loadMap() {
		TextFile tf = new TextFile();
		try {
			tf.openFile(Client.MISSION_DIR + "baghdad3000.csv", TextFile.READ);
			CSVString line = new CSVString(tf.readLine());
			byte size = new Byte(line.getFirstSection()).byteValue();
			Server.map = new SMapData(size);
			for (byte z = 0; z < size; z++) {
				line = new CSVString(tf.readLine());
				//System.out.println(line.toString());
				for (byte x = 0; x < size; x++) {
					byte b = new Byte(line.getSection(x)).byteValue();
					if (b == 99) {
						//this.defender_start_positions.add(new PointF(x + 0.5f, z + 0.5f));
						b = SMapSquare.GRASS;
					}
					SMapSquare.MapSquareFactory(Server.map, x, z, b);
				}
			}
			tf.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		// Place barrels
		// NO AS IT MAKES IT TOO EASY TO KILL THE ENEMY!
		/*    int MAX_BARRELS = 10;
    while (MAX_BARRELS > 0) {
      int x = Functions.rnd(5, Server.map.size -5);
      int z = Functions.rnd(5, Server.map.size -5);
      if (Server.map.getMapSquare(x, z).type == SMapSquare.GRASS) {
        new SBarrel(x+0.5f, z+0.5f);
        MAX_BARRELS--;
      }
    }

    // Place crates
    int MAX_CRATES = 10;
    while (MAX_CRATES > 0) {
      int x = Functions.rnd(5, Server.map.size -5);
      int z = Functions.rnd(5, Server.map.size -5);
      if (Server.map.getMapSquare(x, z).type == SMapSquare.GRASS) {
        new SCrate(x+0.5f, z+0.5f);
        MAX_CRATES--;
      }
    }
		 */
	}

	/*  protected PointF getRandomDefenderPosition() {
    int i = Functions.rnd(0, defender_start_positions.size() - 1);
    PointF p = (PointF) defender_start_positions.get(i);
    defender_start_positions.remove(i);
    return p;
  }
	 */
	public void gameLooped() {
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper.side == Client.ATTACKER) {
			Server.IncVPs(Client.DEFENDER, (byte)17);
		} else if (trooper.side == Client.DEFENDER) {
			Server.IncVPs(Client.ATTACKER, (byte)17);
		}
	}

	public String getOuterWallTexture() {
		return "brick2.png";
	}

	public String getInnerFloorTexture() {
		return "floor02.png";
	}

	public String getDamagedInnerFloorTexture() {
		return "damaged_floor02.png";
	}

	public String getOuterFloorTexture() {
		return "sand.png";
	}

	public String getDamagedOuterFloorTexture() {
		return "damaged_sand.png";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getRoadTexture() {
		return "road1.png";
	}

	public String getDamagedRoadTexture() {
		return "damaged_road1.png";
	}

	public String getStarfieldTexture() {
		return "mineral5.png";
	}

	public String getCeilingTexture() {
		return "beige012.png";
	}

	public String getDamagedCeilingTexture() {
		return "damaged_beige012.png";
	}

	public String getLockedDoorTexture() {
		return "";
	}

	public String getExitTexture() {
		return "";
	}

	public String getDescription() {
		return "The Laser Squad are attempting to invade Baghdad again.  The natives must repel them!  One-player note - both side have AI.";
	}

	public boolean setupAI(byte side) {
		SPlayerObject3D trooper;

		// AI
		AttackSquadAIGroup att_grp = new AttackSquadAIGroup();
		AttackSquadAIGroup def_grp = new AttackSquadAIGroup();

		for(int o=0 ; o<Server.objects.length ; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					trooper = (SPlayerObject3D) Server.objects[o];
					if (trooper.side == side) {
						if (trooper.isComputerControlled() == false) {
							if (trooper.side == Client.ATTACKER) {
								trooper.setAI(new AttackSquadAI(trooper, att_grp));
							} else if (trooper.side == Client.DEFENDER) {
								trooper.setAI(new AttackSquadAI(trooper, def_grp));
							}
						}
					}
				}
			}
		}
		return true;
	}

}
