package ngrave.misc;

import ssmith.io.*;
import ssmith.util.*;
import java.io.IOException;

import ngrave.client.Client;


public final class ItemsFile {

  public String name, desc;
  public int cost, clip_size, shot_aps, damage;
  public float accuracy;
  public boolean can_autofire;

  public ItemsFile() {
  }

  public void getStatsFromCSVFile(byte type) {
    //System.out.println("Getting item "+type);
    TextFile tf = new TextFile();
    try {
        tf.openFile(Client.DATA_DIR + "equipment.csv", TextFile.READ);
        tf.readLine(); // skip header
        CSVString line;
        boolean found = false;
        while (tf.isEOF() == false) {
          line = new CSVString(tf.readLine());
          byte b = new Byte(line.getFirstSection()).byteValue();
          if (b == type) {
            this.name = line.getSection(1);
            this.cost = new Integer(line.getSection(2)).intValue();
            this.damage = new Integer(line.getSection(3)).intValue();
            this.shot_aps = new Integer(line.getSection(4)).intValue();
            this.accuracy = new Float(line.getSection(5)).floatValue();
            this.clip_size = new Integer(line.getSection(6)).intValue();
            this.can_autofire = line.getSection(8).equalsIgnoreCase("Y");
            if (line.getNoOfSections() > 9) {
            	this.desc = line.getSection(9);
            } else {
            	this.desc = "";
            }
            found = true;
            break;
          }
        }
        tf.close();
        if (!found) {
          System.err.println("Cannot find stats for item " + type);
        }
    } catch (IOException e) {
        e.printStackTrace();
    }
  }

}
