package ngrave.client.objects;

import java.io.*;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.shapes.Cube;
import ssmith.opengl.shapes.Cylinder;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;

public class CTable extends CObject implements IClientControlled {

  private static final float HEIGHT = 0.4f;

  private Cube tabletop;
  private Cylinder leg1;

  public CTable(float x, float z) throws IOException {
    super(-1, x, 0f, z, 0, (byte)-1);
    this.x_pos = x+0.5f;
    this.y_pos = 0;
    this.z_pos = z+0.5f;

    tabletop = new Cube(0, HEIGHT, 0, 0.7f, 0.7f, 0.1f, false);
    leg1 = new Cylinder(0, HEIGHT, 0, 0.1f, HEIGHT, 4, false);
  }

	/*public boolean shouldBeDrawn() {
		return true;
	}*/

  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

    super.moveToPosition(gl);

    if (Canvas3D.texture_on) {
      gl.glBindTexture(GL.GL_TEXTURE_2D,
                       Canvas3D.textures.textures[TexLoader.FURNITURE]);
    }
    gl.glColor3f(.25f, 0f, 0.84f);

    tabletop.draw(gl, glu);
    leg1.draw(gl, glu);
  }

  /* (non-Javadoc)
   * @see ngrave.client.IClientControlled#process()
   */
  public void process() {

  }
}
