package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.I3DObject;
import ssmith.opengl.Vector;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;

public class CStarfield implements I3DObject {

                private float angle=0, rotation_speed;

  public CStarfield() {
  	Client.canvas.addObject(this);
    this.rotation_speed = 0.1f;
  }

	public boolean shouldBeDrawn() {
		return true;
	}

	public void draw(GL gl, GLU glu) {
		if (Client.superfast3d) return;

		// Move to the camera so the sky is in the middle
		Vector v = Client.camera.getViewFrom();
	  	gl.glTranslatef(v.x, v.y, v.z);

		gl.glCullFace(GL.GL_FRONT);
		if (Canvas3D.texture_on == false) {
			gl.glColor3f(0f, 0f, 0f);
		} else {
                    gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
		}

		// Show "lightening"? No!
		/*if (Functions.rnd(1, 50) == 1) {
			gl.glDisable(GL.GL_TEXTURE_2D);
		} else {*/
			gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.STARFIELD]);
		//}

		gl.glRotatef(angle, 0f, 1f, 0f);

		glu.gluSphere(Canvas3D.quadratic, Client.canvas.getMaxViewDist()-1, 24, 24);

		angle = angle + this.rotation_speed;
		if (angle > 360) {
			angle = 0;
		}
		gl.glCullFace(GL.GL_BACK);

		if (Canvas3D.texture_on) {
			gl.glEnable(GL.GL_TEXTURE_2D);
		}

	}

}
