package ngrave.client.objects;

import ssmith.lang.*;
import ssmith.opengl.Canvas3D;

import java.io.*;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;

public class CSmoke extends CObject implements IClientControlled {

	public CSmokeBellow smokes[];

	private int timer = 1200, no_of_smokes = 0;

	public CSmoke(float x, float z) throws IOException {
		super(-1, x, 0, z, 0, (byte) -1);
		smokes = new CSmokeBellow[30];
	    //always_draw = true;
	}

	public void process() {
		timer--;
		if (timer <= 0) {
			remove();
		}

		for (int s = 0; s < no_of_smokes; s++) {
			if (smokes[s] != null) {
				smokes[s].process();
			}
		}

	}

	/*public boolean shouldBeDrawn() {
		return true;
	}*/

	public void draw(GL gl, GLU glu) throws IOException {
		if (Client.superfast3d) return;

		if (smokes != null) {
			super.moveToPosition(gl);
			gl.glEnable(GL.GL_BLEND);
			gl.glBlendFunc(GL.GL_ONE, GL.GL_ONE);

			gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.STAR]);

			if (no_of_smokes < smokes.length - 1) {
				if (Functions.rnd(1, 20) == 1) {
					no_of_smokes++;
					smokes[no_of_smokes - 1] = new CSmokeBellow(glu);
				}
			}
			for (int s = 0; s < no_of_smokes; s++) {
				if (smokes[s] != null) {
					smokes[s].draw(gl, glu);
				}
			}

			gl.glDisable(GL.GL_BLEND);
		}

	}

	private static class CSmokeBellow {

		protected float x_pos, y_pos, z_pos, radius = 0, col;
		protected float off_x, off_y, off_z;

		public CSmokeBellow(GLU glu) {
			off_x = Functions.rndFloat(-0.01f, 0.01f);
			off_y = Functions.rndFloat(0.02f, 0.03f);
			off_z = Functions.rndFloat(-0.01f, 0.01f);
			col = Functions.rndFloat(0.2f, 1f);
		}

		public void draw(GL gl, GLU glu) {
			gl.glColor3f(col, col, col);
			gl.glTranslatef(x_pos, y_pos, z_pos);
			glu.gluSphere(Canvas3D.quadratic, radius, 16, 16);
			gl.glTranslatef(-x_pos, -y_pos, -z_pos);
		}

		public void process() {
			radius += 0.003f;

			x_pos = x_pos + off_x;
			y_pos = y_pos + off_y;
			z_pos = z_pos + off_z;
		}

	}


}
