package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.shapes.Cylinder;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;

public class CRocket extends CObject {

  private Cylinder cyl;

  public CRocket(int no, float x, float z, int y_ang, byte owner) {
    super(no, x, 0.7f, z, y_ang, owner);
    cyl = new Cylinder(0f, 0f, 0f, 0.1f, 0.35f, 6, true);
  }

  public void draw(GL gl, GLU glu) {
    super.moveToPosition(gl);
    gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    gl.glBindTexture(GL.GL_TEXTURE_2D,
                     Canvas3D.textures.textures[TexLoader.PLASMA1]);
    cyl.draw(gl, glu);
  }

}
