package ngrave.client.objects;

import java.io.*;
import java.awt.*;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.shapes.Sphere;
import net.java.games.jogl.*;
import ngrave.client.TexLoader;
import ngrave.server.objects.SPlayerObjectZeeker;

public class CPlayerObjectZeeker extends CPlayerObject3D {

  private static final float HEIGHT = 0.7f;

  private Sphere sphere;
  private float r, g, b;

  public CPlayerObjectZeeker(int no, float x, float z, int y_angle, byte side) throws IOException {
    super(no, x, HEIGHT, z, y_angle, side, true, SPlayerObjectZeeker.MOVE_FWD_COST, SPlayerObjectZeeker.RAD);

    sphere = new Sphere(0, 0, 0, SPlayerObjectZeeker.RAD);
    Color c = Color.magenta.darker();
    r = c.getRed()/255f;
    g = c.getGreen()/255f;
    b = c.getBlue()/255f;
  }

  public void draw(GL gl, GLU glu) {
    gl.glColor3f(r, g, b);
    if (Canvas3D.texture_on) {
        gl.glBindTexture(GL.GL_TEXTURE_2D,
                         Canvas3D.textures.textures[TexLoader.TROOPER]);
      }

    super.moveToPosition(gl);
    sphere.draw(gl, glu);
  }

}
