package ngrave.client.objects;

import java.io.*;
import java.awt.*;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.shapes.Cylinder;
import net.java.games.jogl.*;
import ngrave.client.TexLoader;
import ngrave.server.objects.SPlayerObjectRobot;

public class CPlayerObjectRobot extends CPlayerObject3D {

  private static final float HEIGHT = 0.6f;

  private Cylinder body, probe;
  private float br, bg, bb, pr, pg, pb;

  public CPlayerObjectRobot(int no, float x, float z, int y_ang, byte side) throws IOException {
    super(no, x, HEIGHT, z, y_ang, side, true, SPlayerObjectRobot.MOVE_FWD_COST, SPlayerObjectRobot.DIAM/2);

    body = new Cylinder(0f, 0f, 0f, (SPlayerObjectRobot.DIAM/2)-.05f, HEIGHT, 10, 90, SPlayerObjectRobot.DIAM/2);
    probe = new Cylinder(0, 0, 0, 0.05f, SPlayerObjectRobot.DIAM, 8, true);

    Color col1 = Color.cyan;
    br = col1.getRed() / 255f;
    bg = col1.getGreen() / 255f;
    bb = col1.getBlue() / 255f;

    col1 = col1.darker();
    pr = col1.getRed() / 255f;
    pg = col1.getGreen() / 255f;
    pb = col1.getBlue() / 255f;

  }

  public void draw(GL gl, GLU glu) {
    super.moveToPosition(gl);

    Color col1 = Color.cyan;
    gl.glColor3f(br, bg, bb);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.TROOPER]);

    body.draw(gl, glu);

    col1 = col1.darker();
    gl.glColor3f(pr, pg, pb);
    probe.draw(gl, glu);
  }

}
