package ngrave.client.objects;

import java.awt.Color;
import java.io.*;

import net.java.games.jogl.*;
import ngrave.server.objects.SPlayerObjectPrisoner;

public class CPlayerObjectPrisoner extends CPlayerObject3D {

  private static final float HEIGHT = 0.7f;

  private CPersonModel person;

  public CPlayerObjectPrisoner(int no, float x, float z, int y_angle, byte side) throws IOException {
    super(no, x, HEIGHT, z, y_angle, side, true, SPlayerObjectPrisoner.MOVE_FWD_COST, SPlayerObjectPrisoner.DIAM/2);

    person = new CPersonModel(Color.WHITE);
  }

  public void animateMovement() {
  	person.animateMovement();
  }
  
  public void draw(GL gl, GLU glu) {
  	if (person != null) {
  		super.moveToPosition(gl);
  		
  		person.draw(gl, glu);
  	}
  	
  }
  
}
