package ngrave.client.objects;

import java.io.*;
import java.awt.*;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.TexLoader;
import ngrave.server.objects.SPlayerObjectBattleBot;

public class CPlayerObjectBattleBot extends CPlayerObject3D {

  public static final float HEIGHT = 0.9f;
  private float r, g, b;
  private float rd, gd, bd;
  private float rdd, gdd, bdd;

  public CPlayerObjectBattleBot(int no, float x, float z, int y_ang, byte side) throws IOException {
    super(no, x, HEIGHT, z, y_ang, side, true, SPlayerObjectBattleBot.MOVE_FWD_COST, SPlayerObjectBattleBot.DIAM/2);

    Color col1 = Color.BLUE.darker().darker();
    rdd = col1.getRed() / 255f;
    gdd = col1.getGreen() / 255f;
    bdd = col1.getBlue() / 255f;

    col1 = Color.BLUE.darker();
    rd = col1.getRed() / 255f;
    gd = col1.getGreen() / 255f;
    bd = col1.getBlue() / 255f;

    col1 = Color.BLUE;
    r = col1.getRed() / 255f;
    g = col1.getGreen() / 255f;
    b = col1.getBlue() / 255f;
}

  public void draw(GL gl, GLU glu) {
    super.moveToPosition(gl);

    if (Canvas3D.texture_on) {
      gl.glBindTexture(GL.GL_TEXTURE_2D,
                       Canvas3D.textures.textures[TexLoader.TROOPER]);
    }

    // Move down by the HEIGHT so the tank is on the ground
    gl.glTranslatef(0, -HEIGHT, 0f);

    // Draw the object

    // Front
    float half_width = SPlayerObjectBattleBot.DIAM / 2;
    float height = HEIGHT;

      gl.glColor3f(r, g, b);

    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f( -half_width, height, -half_width);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f(half_width, height, -half_width);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(half_width, 0.0f, -half_width);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f( -half_width, 0.0f, -half_width);
    gl.glEnd();

    // Right
      gl.glColor3f(rdd, gdd, bdd);

    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f(half_width, height, -half_width);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f(half_width, height, half_width);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(half_width, 0.0f, half_width);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(half_width, 0.0f, -half_width);
    gl.glEnd();

    // back
      gl.glColor3f(rd, gd, bd);

    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f(half_width, height, half_width);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f( -half_width, height, half_width);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(-half_width, 0f, half_width);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(half_width, 0f, half_width);
    gl.glEnd();

    // Left
      gl.glColor3f(r, g, b);

    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f( -half_width, height, half_width);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f( -half_width, height, -half_width);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f( -half_width, 0.0f, -half_width);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f( -half_width, 0.0f, half_width);
    gl.glEnd();

    // Top of base
    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f( -half_width, height, -half_width);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f( -half_width, height, half_width);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(half_width, height, half_width);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(half_width, height, -half_width);
    gl.glEnd();

    // Barrel
    if (Canvas3D.texture_on == false) {
      gl.glColor3f(rd, gd, bd);
    }

    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f(0f, height - 0.1f, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f(0f, height, 0f);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(0f, height, -half_width*2);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(0f, height - 0.1f, -half_width*2);

    // Right side
    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f(0f, height - 0.1f, -half_width*2);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f(0f, height, -half_width*2);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(0f, height, 0f);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(0f, height - 0.1f, 0f);

    gl.glEnd();

  }

}
