package ngrave.client.objects;

import ssmith.lang.Functions;
import ssmith.opengl.Canvas3D;

import java.io.*;

import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.objects.SPlayerObjectAlien;

public class CPlayerObjectAlien extends CPlayerObject3D {

  private static final float MAX_RAD=0.4f, MIN_RAD=0.2f, HEIGHT=0.5f;

  private float curr_rad;
  private float size_diff = Functions.rndFloat(0.005f, 0.015f);

  public CPlayerObjectAlien(int no, float x, float z, int y_ang, byte side) throws IOException {
    super(no, x, HEIGHT, z, y_ang, side, true, SPlayerObjectAlien.MOVE_FWD_COST, SPlayerObjectAlien.COLLISION_DIAM);
    this.curr_rad = Functions.rndFloat(MIN_RAD, MAX_RAD);

  }

  public void draw(GL gl, GLU glu) {
    super.moveToPosition(gl);
    gl.glBindTexture(GL.GL_TEXTURE_2D,
                     Canvas3D.textures.textures[TexLoader.ALIEN_SKIN]);
    if (Canvas3D.texture_on) {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    } else {
      gl.glColor3f(0f, 1f, 0f);
    }
    gl.glTranslatef(0f, curr_rad - super.y_pos, 0f); // Raise them by their height.
    glu.gluSphere(Canvas3D.quadratic, curr_rad, 16, 16);

    curr_rad = curr_rad + size_diff;
    if (curr_rad > MAX_RAD) {
      size_diff = size_diff * -1;
    } else if (curr_rad < MIN_RAD) {
      size_diff = size_diff * -1;
    }

  }

}
