package ngrave.client.objects;

import java.awt.*;
import java.util.*;
import java.io.*;

import ssmith.game.ICollidableObject;
import ssmith.lang.Functions;
import net.java.games.jogl.*;
import ngrave.client.C2SCommunication;
import ngrave.client.CItemCarried;
import ngrave.client.CPlayerData;
import ngrave.client.Client;
import ngrave.server.Server;
import ngrave.server.Statics;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.shared.PlayerObject3D;
import ssmith.util.Interval;

public abstract class CPlayerObject3D extends CObject implements ICollidableObject {

	public static final int TROOPER_SELECTOR_WIDTH = 100, TROOPER_SELECTOR_HEIGHT=91;

	public String name = "Unknown";
	private int health, been_hit_timer;
	public int combat;
	public int armour_damage_reduction;
	private int shot_type = SPlayerObject3D.NORMAL_SHOT;
	public float accuracy;
	private float action_points = Server.MAX_ACTION_POINTS;
	private boolean can_see_enemy = false;
	private boolean autofire = Client.DEFAULT_AUTOFIRE;
	private boolean guard = false;
	private ArrayList items = new ArrayList();
	private CItemCarried current_item;
	private CPlayerData current_controller;
	protected final float move_fwd_cost, radius;
	private static Interval footstep_interval = new Interval(500);

	public CPlayerObject3D(int no, float x, float y, float z, int y_ang, byte owner, boolean controllable, float move_cost, float rad) {
		super(no, x, y, z, y_ang, owner);

		this.move_fwd_cost = move_cost;
		this.radius = rad;
		Client.coll_matrix.addObject(this);

		// Increase their troop count.
		if (owner == Client.players.getThisPlayer().side && controllable) {
			Client.units_on_my_side.add(this);
		}
	}

	public boolean turnIfEnoughAPs(int degrees) throws IOException {
		float cost = Functions.mod(Client.TURN_COST * degrees);
		if (this.action_points >= cost) {
			this.y_angle += degrees; // Left is +, Right is -
			if (this.y_angle < 0) {
				this.y_angle += 360;
			}
			if (this.y_angle >= 360) {
				this.y_angle -= 360;
			}
			this.action_points -= cost;
			Client.map.recalcVisibleSquares(true, true);
			//if (send_angle_interval.hitInterval()) { NO AS THE SERVER NEEDS TO KNOW THE EXACT ANGLE!
			C2SCommunication.SendAngle(this);
			//}
			return true;
		} else {
			Client.sfx.playSound(Statics.SOUND_DIR + "aps_out.wav");
		}
		return false;
	}

	public CItemCarried getItem(int no) {
		CItemCarried item;
		for (int i=0 ; i<items.size() ; i++) {
			item = (CItemCarried) items.get(i);
			if (item.no == no) {
				return item;
			}
		}
		return null;
	}

	public int getShotType() {
		return this.shot_type;
	}

	public void toggleShotType() throws IOException {
		shot_type++;
		if (shot_type > SPlayerObject3D.AIMED_SHOT) {
			shot_type = SPlayerObject3D.SNAP_SHOT;
		}
		Client.sfx.playSound(Statics.SOUND_DIR + "toggle2.wav");
		C2SCommunication.SendShotType(this);
	}

	public void setShotType(int t) throws IOException {
		this.shot_type = t;

		Client.sfx.playSound(Statics.SOUND_DIR + "toggle2.wav");
		C2SCommunication.SendShotType(this);
	}

	public String getShotTypeName() {
		switch (shot_type) {
		case SPlayerObject3D.SNAP_SHOT:
			return "Shot type: Snapshot";
		case SPlayerObject3D.NORMAL_SHOT:
			return "Shot type: Normal";
		case SPlayerObject3D.AIMED_SHOT:
			return "Shot type: Aimed";
		default:
			return "Shot type: Unknown";
		}
	}

	public void addItem(CItemCarried item) throws IOException {
		this.items.add(item);
		if (items.size() == 1) { // Select first item
			selectFirstItem();
		}
	}

	public void removeItem(int no) {
		CItemCarried item;
		for (int i=0 ; i<items.size() ; i++) {
			item = (CItemCarried) items.get(i);
			if (item.no == no) {
				items.remove(i);
				if (this.current_item == item) {
					this.current_item = null;
				}
			}
		}
	}

	public void removeAllItems() {
		this.items.removeAll(items);
		this.current_item = null;
	}

	public void selectFirstItem() throws IOException {
		if (this.items.size() > 0) {
			this.current_item = (CItemCarried) items.get(0);
			C2SCommunication.SendChangedItem(this);
		}
	}

	public void toggleAutofire() throws IOException {
		this.setAutofire(!this.isAutofiring(), true);
	}

	public void toggleGuard() throws IOException {
		this.setGuard(!this.isGuarding(), true);
	}

	/**
	 * This draws their box at the top of the screen.
	 */
	public void draw(Graphics g) {
		if (this.been_hit_timer > 0) {
			g.setColor(Color.RED);
			g.fillRect(-5, -15, TROOPER_SELECTOR_WIDTH, TROOPER_SELECTOR_HEIGHT);
			this.been_hit_timer -= 15;
		}
		if (this == Client.current_unit) {
			// Draw box round it
			g.setColor(Color.yellow);
			g.drawRect(-5, -15, TROOPER_SELECTOR_WIDTH, TROOPER_SELECTOR_HEIGHT);
		}

		if (this.can_see_enemy) {
			g.setColor(Color.red);
		} else if (action_points < Server.MAX_ACTION_POINTS) {
			g.setColor(Color.lightGray);
		} else {
			g.setColor(Color.white);
		}
		if (this.current_controller != null) {
			g.drawString(this.current_controller.getName(), 0, 0);
		}
		g.drawString(this.name, 0, 14);
		g.drawString("APs: " + (int) (this.action_points), 0, 28);
		g.setColor(Color.white);
		g.drawString("Health: "+this.health, 0, 42);
		//g.drawString("Armour: "+this.armour_damage_reduction, 0, 42);
		if (this.current_item != null) {
			int ammo = getAmmo();
			if (ammo > 0) {
				g.setColor(Color.white);
			}
			else {
				g.setColor(Color.red);
			}
			g.drawString(current_item.name + ": " + ammo, 0, 56);
		}
		g.setColor(Color.white);
		if (this.autofire) {
			g.setColor(Color.yellow);
			g.drawString("AUTO", 0, 70);
		}
		if (this.guard) {
			g.setColor(Color.GREEN);
			g.drawString("GRD", 32, 70);
		}
		g.setColor(Color.WHITE);
		if (this.shot_type == SPlayerObject3D.SNAP_SHOT) {
			g.drawString("SNAP", 57, 70);
		} else if (this.shot_type == SPlayerObject3D.AIMED_SHOT) {
			g.drawString("AIM", 57, 70);
		} else {
			g.drawString("NRML", 57, 70);
		}
	}

	private int getAmmo() {
		return current_item.ammo;
	}

	protected void drawItem(GL gl, GLU glu) {
		if (this.current_item != null) {
			this.current_item.drawCarried(gl, glu);
		}
	}

	public ListIterator getItemsEnumeration() {
		return items.listIterator();
	}

	public void setCurrentItem(CItemCarried item) throws IOException {
		if (item != current_item)
			if (this.action_points >= SPlayerObject3D.CHANGE_ITEM_COST) {
				this.current_item = item;
				C2SCommunication.SendChangedItem(this);
			} else {
				Client.log.addMessage("Not enough APs.", (byte)1);
			}
	}

	public CItemCarried getCurrentItem() {
		return this.current_item;
	}

	public void removeCurrentItem() throws IOException {
		this.current_item = null;
		C2SCommunication.SendChangedItem(this);
	}

	public boolean isGuarding() {
		return this.guard;
	}

	public void setGuard(boolean s, boolean send_comms) throws IOException {
		if (guard != s) {
			this.guard = s;
			if (Functions.rnd(1, 5) == 1) {
				this.sendMessageToOwner(name + ": My trigger finger's getting itchy.");
			}
			if (send_comms) {
				C2SCommunication.SendGuard(this);
			}
			Client.sfx.playSound(Statics.SOUND_DIR + "toggle2.wav");
		}
	}

	public boolean isAutofiring() {
		return this.autofire;
	}

	public void setAutofire(boolean s, boolean send_comms) throws IOException {
		if (this.autofire != s){
			this.autofire = s;
			if (s) {
			if (Functions.rnd(1, 5) == 1) {
				this.sendMessageToOwner(name + ": Ready to shoot on-sight!");
			}
			}
			if (send_comms) {
				C2SCommunication.SendAutofire(this);
			}
			Client.sfx.playSound(Statics.SOUND_DIR + "toggle2.wav");
		}
	}

	/**
	 * This should only be called if the state has changed.
	 * @param b
	 */
	public void setCanSeeEnemy(boolean b) {
		this.can_see_enemy = b;
		if (b) {
			sendMessageToOwner(this.name + ": \"Enemy sighted!\"");
		}
	}
	
	public void sendMessageToOwner(String msg) {
		if (this.getOwner() == Client.players.getThisPlayer().side) {
			Client.log.addMessage(msg, 0);
		}
	}

	public void setCurrentController(CPlayerData player) {
		this.current_controller = player;

		if (Client.DEBUG) {
			if (player != null) {
				System.out.println(this.name + " now controlled by " + player.getName());
			} else {
				System.out.println(this.name + " now controlled by no-one");
			}
		}

		if (player == Client.players.getThisPlayer()) {
			Client.current_unit = this;
			Client.camera.showFromTrooper(this);
		}

	}

	public void moveForwardsIfEnoughAPs() throws IOException {
		float cost = move_fwd_cost * Client.MOVE_SPEED;
		cost = PlayerObject3D.adjustCostForArmour(this.armour_damage_reduction, cost);
		if (this.getAPs() >= cost) {
			if (attemptMoveForwards()) {
				if (footstep_interval.hitInterval()) {
					Client.sfx.playSound(Statics.SOUND_DIR + "footstep.wav");
				}
				Client.map.recalcVisibleSquares(false, false);
				C2SCommunication.SendUnitsLocation(this);
				this.reduceAPs(cost);
			}
		} else {
			Client.sfx.playSound(Statics.SOUND_DIR + "aps_out.wav");
		}
	}

	public void moveBackwardsIfEnoughAPs() throws IOException {
		float cost = move_fwd_cost * Client.MOVE_SPEED;
		cost = PlayerObject3D.adjustCostForArmour(this.armour_damage_reduction, cost);
		if (this.getAPs() >= cost) {
			if (attemptMoveBackwards()) {
				if (footstep_interval.hitInterval()) {
					Client.sfx.playSound(Statics.SOUND_DIR + "footstep.wav");
				}
				Client.map.recalcVisibleSquares(false, false);
				C2SCommunication.SendUnitsLocation(this);
				this.reduceAPs(cost);
			}
		} else {
			Client.sfx.playSound(Statics.SOUND_DIR + "aps_out.wav");
		}
	}

	public boolean slideLeftIfEnoughAPs() throws IOException {
		float cost = move_fwd_cost * Client.MOVE_SPEED;
		cost = PlayerObject3D.adjustCostForArmour(this.armour_damage_reduction, cost);
		if (this.getAPs() >= cost) {
			if (attemptSlideLeft()) {
				if (footstep_interval.hitInterval()) {
					Client.sfx.playSound(Statics.SOUND_DIR + "footstep.wav");
				}
				Client.map.recalcVisibleSquares(false, false);
				C2SCommunication.SendUnitsLocation(this);
				this.reduceAPs(cost);
			}
			return true;
		} else {
			Client.sfx.playSound(Statics.SOUND_DIR + "aps_out.wav");
		}
		return false;
	}

	public boolean slideRightIfEnoughAPs() throws IOException {
		float cost = move_fwd_cost * Client.MOVE_SPEED;
		cost = PlayerObject3D.adjustCostForArmour(this.armour_damage_reduction, cost);
		if (this.getAPs() >= cost) {
			if (attemptSlideRight()) {
				if (footstep_interval.hitInterval()) {
					Client.sfx.playSound(Statics.SOUND_DIR + "footstep.wav");
				}
				Client.map.recalcVisibleSquares(false, false);
				C2SCommunication.SendUnitsLocation(this);
				this.reduceAPs(cost);
			}
			return true;
		} else {
			Client.sfx.playSound(Statics.SOUND_DIR + "aps_out.wav");
		}
		//}
		return false;
	}

	/**
	 * This is PRIVATE as it shouldn't be called from anywhere else!
	 *
	 * @return
	 * @throws IOException
	 * @throws IOException
	 */
	private boolean attemptSlideLeft() throws IOException {
		slideLeftRegardless(Client.MOVE_SPEED * Statics.SLIDE_MOD);
		boolean success = true;
		if (this.canTraverseMap() == false) {
			success = false;
		} else {
			CObject obj = this.hasCollided();
			if (obj != null) {
				success = false;
				C2SCommunication.SendObjectsCollided(this, obj);
			}
		}
		if (success == false) {
			slideRightRegardless(Client.MOVE_SPEED * Statics.SLIDE_MOD);
			return false;
		} else {
			return true;
		}
	}

	/**
	 *  This is PRIVATE as it shouldn't be called from anywhere else!
	 *
	 * @return
	 * @throws IOException
	 */
	private boolean attemptSlideRight() throws IOException {
		slideRightRegardless(Client.MOVE_SPEED * Statics.SLIDE_MOD);
		boolean success = true;
		if (this.canTraverseMap() == false) {
			success = false;
		} else {
			CObject obj = this.hasCollided();
			if (obj != null) {
				success = false;
				C2SCommunication.SendObjectsCollided(this, obj);
			}
		}
		if (success == false) {
			slideLeftRegardless(Client.MOVE_SPEED * Statics.SLIDE_MOD);
			return false;
		} else {
			return true;
		}
	}

	protected boolean slideLeftRegardless(float dist) {
		//if (this.can_collide) {
		Client.coll_matrix.removeObject(this);
		//}
		float x = (float) Math.sin(Math.toRadians(y_angle+90)) * dist;
		x_pos -= x;
		float z = (float) Math.cos(Math.toRadians(y_angle+90)) * dist;
		z_pos -= z;
		//if (this.can_collide) {
		Client.coll_matrix.addObject(this);
		//}
		return true;
	}

	protected boolean slideRightRegardless(float dist) {
		//if (this.can_collide) {
		Client.coll_matrix.removeObject(this);
		//}
		float x = (float) Math.sin(Math.toRadians(y_angle-90)) * dist;
		x_pos -= x;
		float z = (float) Math.cos(Math.toRadians(y_angle-90)) * dist;
		z_pos -= z;
		//if (this.can_collide) {
		Client.coll_matrix.addObject(this);
		//}
		return true;
	}

	/** This is PRIVATE as it shouldn't be called from anywhere else!
	 *
	 * @return
	 * @throws IOException
	 */
	private boolean attemptMoveForwards() throws IOException {
		//System.out.println(this.name + " is moving forwards");
		moveForwardsRegardless();
		if (this.canTraverseMap() == false) {
			moveBackwardsRegardless();
			return false;
		} else {
			CObject obj = this.hasCollided();
			if (obj != null) {
				C2SCommunication.SendObjectsCollided(this, obj);
				moveBackwardsRegardless();
				return false;
			}
		}
		return true;
	}

	private boolean attemptMoveBackwards() throws IOException {
		//System.out.println(this.name + " is moving forwards");
		moveBackwardsRegardless();
		if (this.canTraverseMap() == false) {
			moveForwardsRegardless();
			return false;
		} else {
			CObject obj = this.hasCollided();
			if (obj != null) {
				C2SCommunication.SendObjectsCollided(this, obj);
				moveForwardsRegardless();
				return false;
			}
		}
		return true;
	}

	private void moveForwardsRegardless() {
		//if (this.can_collide) {
		Client.coll_matrix.removeObject(this);
		//}
		/*if (move_dir.x == 0 && move_dir.y == 0) {
         System.err.println("Unit " + this.toString() + " has no move dir!");
     }*/
		//todo - store move direction?
		float x = (float) Math.sin(Math.toRadians(y_angle)) * Client.MOVE_SPEED; // todo - take as param
		x_pos -= x;//this.move_dir.x;
		float z = (float) Math.cos(Math.toRadians(y_angle)) * Client.MOVE_SPEED; // todo - take as param
		z_pos -= z;//this.move_dir.y;
		//if (this.can_collide) {
		Client.coll_matrix.addObject(this);
		//}

	}

	private void moveBackwardsRegardless() {
		//if (this.can_collide) {
		Client.coll_matrix.removeObject(this);
		//}
		/*if (move_dir.x == 0 && move_dir.y == 0) {
         System.err.println("Unit " + this.toString() + " has no move dir!");
     }*/
		float x = (float) Math.sin(Math.toRadians(y_angle)) * Client.MOVE_SPEED; // todo - take as param
		x_pos += x;//this.move_dir.x;
		float z = (float) Math.cos(Math.toRadians(y_angle)) * Client.MOVE_SPEED; // todo - take as param
		z_pos += z;//this.move_dir.y;
		//if (this.can_collide) {
		Client.coll_matrix.addObject(this);
		//}

	}

	/**
	 * This returns true if they have collided
	 * @return
	 */
	protected CObject hasCollided() {
		//boolean result = false;
		ArrayList objs = Client.coll_matrix.getPotentialColliders(this);
		CPlayerObject3D obj;
		int size = objs.size();
		for (int o=0 ; o<size ; o++) {
			//System.out.println("Type:" + objs.get(o).toString());
			obj = (CPlayerObject3D)objs.get(o);
			if (obj instanceof ICollidableObject) {
				if (this.isWithinCollidingDistance(obj)) {
					return obj;
					/*if (this.hasCollidedWith(obj)) {
                    if (nmr != null) {
                        nmr.setBlockedByObject(obj);
                    }
                    result = true;
                             }
                             if (this.destroyed) {
                    // No point continuing.
                    return result;
                             }*/
				}
			}
		}
		return null;
	}

	protected boolean isWithinCollidingDistance(CPlayerObject3D other) {
		if (Functions.distance(this.x_pos, this.z_pos, other.x_pos, other.z_pos) <= (this.radius+other.radius)) {
			return true;
		} else {
			return false;
		}
	}

	public boolean canTraverseMap() {
		return canTraverseMapTL() && canTraverseMapTR() && canTraverseMapBL() && canTraverseMapBR();
	}

	private boolean canTraverseMapTL() {
		return canTraverse(Client.map.getMapSquare(this.x_pos+(radius), this.z_pos-(radius)));
	}

	private boolean canTraverseMapTR() {
		return canTraverse(Client.map.getMapSquare(this.x_pos+(radius), this.z_pos+(radius)));
	}

	private boolean canTraverseMapBL() {
		return canTraverse(Client.map.getMapSquare(this.x_pos-(radius), this.z_pos-(radius)));
	}

	private boolean canTraverseMapBR() {
		return canTraverse(Client.map.getMapSquare(this.x_pos-(radius), this.z_pos+(radius)));
	}

	//public abstract boolean canTraverse(CMapSquare sq);

	public float getAPs() {
		return this.action_points;
	}

	public void reduceAPs(float amt) {
		this.action_points -= amt;
	}

	public void setAPs(float amt) {
		this.action_points = amt;
	}

	public void remove() {
		Client.coll_matrix.removeObject(this);
		super.remove();
	}

	public float getX() {
		return this.x_pos;
	}

	public float getZ() {
		return this.z_pos;
	}

	public float getRadius() {
		return this.radius;
	}

	public boolean canTraverse(CMapSquare sq) {
		return sq.blocks_movement == false; // < SMapSquare.START_OF_VIEW_BLOCKERS;
	}

	public void setLocation(float x, float z) {
		Client.coll_matrix.removeObject(this);
		super.setLocation(x, z);
		Client.coll_matrix.addObject(this);
	}

	public void setHealth(int new_health) {
		if (new_health < this.health) {
			// Been hit!
			this.been_hit_timer = 255;
			if (new_health > 0) {
				Client.sfx.playSound(Statics.SOUND_DIR + "hit1.wav");
				if (Functions.rnd(1, 5) == 1) {
					this.sendMessageToOwner(name + ": Aaaargghhh!");
				}
			} else {
				Client.sfx.playSound(Statics.SOUND_DIR + "deathscream" + (this.getOwner()+1) + ".wav");
			}
		}
		this.health = new_health;
	}

	public int getHealth() {
		return this.health;
	}

}

