package ngrave.client.objects;

import ssmith.lang.*;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;

/**
 * @author stephen smith
 *
 */
public class CPlanet extends CObject implements IClientControlled {

  public static final float RADIUS = 15f;

  public CPlanet() {
  	super(-1, 0f, 0f, 0f, 0, (byte)-1);
    x_pos = Functions.rnd(-10, 50);
    y_pos = 30f;
    z_pos = Functions.rnd(-10, 50);
    //always_draw = true;
  }

	public void draw(GL gl, GLU glu) {
		if (Client.superfast3d) return;

	  	gl.glDisable(GL.GL_DEPTH_TEST);
	    super.moveToPosition(gl);

	    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.PLANET]);

            gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
	    glu.gluSphere(Canvas3D.quadratic, RADIUS, 32, 32);
	  	gl.glEnable(GL.GL_DEPTH_TEST);
	  }

	public boolean shouldBeDrawn() {
		if (Client.camera.isLockedToTrooper()) {
			return true;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see ngrave.client.IClientControlled#process()
	 */
	public void process() {
		// Nothing

	}

}
