package ngrave.client.objects;

import ssmith.lang.Functions;
import ssmith.opengl.Canvas3D;
import java.io.*;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CPicture extends CObject implements IClientControlled {

	private int pic_texture;

	public CPicture() throws IOException {
		super(-1, 0f, 0.0f, 0f, 0, (byte)-1);

		int p = Functions.rnd(1, 4);
		switch (p) {
			case 1:
				this.pic_texture = TexLoader.POSTER1;
				break;
			case 2:
				this.pic_texture = TexLoader.POSTER2;
				break;
			case 3:
				this.pic_texture = TexLoader.POSTER3;
				break;
			case 4:
				this.pic_texture = TexLoader.POSTER4;
				break;
			default:
				System.err.println("Unknown pic texure.");
			}

		boolean placed = false;
		while (!placed) {
			int x = Functions.rnd(1, Client.getMapSize()-2);
			int z = Functions.rnd(1, Client.getMapSize()-2);
			if (Client.map.getMapSquare(x, z).type == SMapSquare.WALL) {
				if (Client.map.getMapSquare(x-1, z).type == SMapSquare.FLOOR) {
					this.x_pos = x-0.01f;
					this.z_pos = z+0.5f;
					this.y_angle = 270;
					placed = true;
				} else if (Client.map.getMapSquare(x+1, z).type == SMapSquare.FLOOR) {
					this.x_pos = x+1.01f;
					this.z_pos = z+0.5f;
					this.y_angle = 90;
					placed = true;
				} else if (Client.map.getMapSquare(x, z-1).type == SMapSquare.FLOOR) {
					this.x_pos = x+0.5f;
					this.z_pos = z-0.01f;
					this.y_angle = 180;
					placed = true;
				} else if (Client.map.getMapSquare(x, z+1).type == SMapSquare.FLOOR) {
					this.x_pos = x+0.5f;
					this.z_pos = z+1.01f;
					this.y_angle = 0;
					placed = true;
				}
			}
		}
		//System.out.println("Pic placed at "+this.x_pos+","+this.z_pos);
	}

	public void draw(GL gl, GLU glu) {
		if (Client.superfast3d) return;

		super.moveToPosition(gl);

                gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
		gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[this.pic_texture]);

		gl.glBegin(GL.GL_QUADS);
		gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(-.25f, 0.25f, 0);
		gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0.25f, 0.25f, 0);
		gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(0.25f, 0.75f, 0);
		gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(-0.25f, 0.75f, 0);

		gl.glEnd();
	}

	/* (non-Javadoc)
	 * @see ngrave.client.IClientControlled#process()
	 */
	public void process() {
	}

/*	public boolean shouldBeDrawn() {
		return true;
	}*/
}

