package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.shapes.Cube;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareWindow extends CMapSquare {

  private static final float WINDOW_PANELS_HEIGHT = 0.2f;

  private Cube top, bottom;

  public CMapSquareWindow(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.WINDOW);

    top = new Cube(0.5f, 1-(WINDOW_PANELS_HEIGHT/2), 0.5f, 1f, 1f, WINDOW_PANELS_HEIGHT, true);
    bottom = new Cube(0.5f, WINDOW_PANELS_HEIGHT/2, 0.5f, 1f, 1f, WINDOW_PANELS_HEIGHT, false);
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, 0, z);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.OUTER_WALL]);

    if (Canvas3D.texture_on == false) {
        gl.glColor3f(1f, 0.941f, 0.737f);
      } else {
          gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
      }

    top.draw(gl, glu);
    bottom.draw(gl, glu);

    gl.glTranslatef( -x, 0, -z);

  }

}

