package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.Model;
import ssmith.opengl.shapes.Cube;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareWall extends CMapSquare {

  public boolean draw_n=true, draw_s=true, draw_e=true, draw_w=true;

  private static boolean compiled = false;
  private static int list_no;
  
  public CMapSquareWall(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.WALL);
  }

  public void draw(GL gl, GLU glu) {
	  if (compiled == false) {
		  list_no = gl.glGenLists(Model.getNextListNo());
		  gl.glNewList(list_no, GL.GL_COMPILE);

		  gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.OUTER_WALL]);

		  gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
		  
		  Cube c = new Cube(.5f, .5f, .5f, 1f, false);
		  c.draw(gl, glu);

		  /*gl.glBegin(GL.GL_QUADS);

		  // Front/north
		  if (draw_n) {
			  if (Canvas3D.texture_on == false) {
				  gl.glColor3f(1f, 0.941f, 0.737f);
			  }
			  gl.glNormal3f(0f, 0f, -1f);
			  gl.glTexCoord2f(0.0f, 0.0f);
			  gl.glVertex3f(0.0f, 1.0f, 0.0f);
			  gl.glTexCoord2f(1.0f, 0.0f);
			  gl.glVertex3f(1.0f, 1.0f, 0.0f);
			  gl.glTexCoord2f(1.0f, 1.0f);
			  gl.glVertex3f(1.0f, 0.0f, 0.0f);
			  gl.glTexCoord2f(0.0f, 1.0f);
			  gl.glVertex3f(0.0f, 0.0f, 0.0f);
		  }

		  // Right/east
		  if (draw_e) {
			  if (Canvas3D.texture_on == false) {
				  gl.glColor3f(1f, 0.901f, 0.572f);
			  }
			  gl.glNormal3f(-1f, 0f, 0f);
			  gl.glTexCoord2f(0.0f, 0.0f);
			  gl.glVertex3f(1.0f, 1.0f, 0.0f);
			  gl.glTexCoord2f(1.0f, 0.0f);
			  gl.glVertex3f(1.0f, 1.0f, 1.0f);
			  gl.glTexCoord2f(1.0f, 1.0f);
			  gl.glVertex3f(1.0f, 0.0f, 1.0f);
			  gl.glTexCoord2f(0.0f, 1.0f);
			  gl.glVertex3f(1.0f, 0.0f, 0.0f);
		  }

		  // back/south
		  if (draw_s) {
			  if (Canvas3D.texture_on == false) {
				  gl.glColor3f(1f, 0.941f, 0.737f);
			  }
			  gl.glNormal3f(0f, 0f, 1f);
			  gl.glTexCoord2f(0.0f, 0.0f);
			  gl.glVertex3f(1.0f, 1.0f, 1.0f);
			  gl.glTexCoord2f(1.0f, 0.0f);
			  gl.glVertex3f(0.0f, 1.0f, 1.0f);
			  gl.glTexCoord2f(1.0f, 1.0f);
			  gl.glVertex3f(0.0f, 0.0f, 1.0f);
			  gl.glTexCoord2f(0.0f, 1.0f);
			  gl.glVertex3f(1.0f, 0.0f, 1.0f);
		  }

		  // left/west
		  if (draw_w) {
			  if (Canvas3D.texture_on == false) {
				  gl.glColor3f(1f, 0.901f, 0.572f);
			  }
			  else {
				  gl.glColor3f(Client.GREY_D, Client.GREY_D, Client.GREY_D);
			  }
			  gl.glNormal3f(1f, 0f, 0f);
			  gl.glTexCoord2f(0.0f, 0.0f);
			  gl.glVertex3f(0.0f, 1.0f, 0.0f);
			  gl.glTexCoord2f(0.0f, 1.0f);
			  gl.glVertex3f(0.0f, 0.0f, 0.0f);
			  gl.glTexCoord2f(1.0f, 1.0f);
			  gl.glVertex3f(0.0f, 0.0f, 1.0f);
			  gl.glTexCoord2f(1.0f, 0.0f);
			  gl.glVertex3f(0.0f, 1.0f, 1.0f);
		  }

		  // Top
		  if (Client.camera.isLockedToTrooper() == false) {
			  if (Canvas3D.texture_on == false) {
				  gl.glColor3f(1f, 0.941f, 0.737f);
			  }
			  gl.glNormal3f(0f, 1f, 0f);
			  gl.glTexCoord2f(0.0f, 0.0f);
			  gl.glVertex3f(0f, 1f, 1f);
			  gl.glTexCoord2f(1.0f, 0.0f);
			  gl.glVertex3f(1f, 1f, 1f);
			  gl.glTexCoord2f(1.0f, 1.0f);
			  gl.glVertex3f(1f, 1f, 0f);
			  gl.glTexCoord2f(0.0f, 1.0f);
			  gl.glVertex3f(0f, 1f, 0f);
		  }

		  gl.glEnd();
*/
          gl.glEndList();

          compiled = true;
	  }
  
	  gl.glTranslatef(x, 0, z);
	  gl.glCallList(list_no);
	  gl.glTranslatef( -x, -0, -z);

  }

}

