package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.shapes.Cube;
import ssmith.opengl.shapes.Cylinder;
import net.java.games.jogl.*;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareTruckTrailer extends CMapSquare {
	
	private static final float WHEEL_RAD = 0.2f;
	private Cylinder wheel1, wheel2;
	private Cube base;

  public CMapSquareTruckTrailer(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.ROAD);
    
    wheel1 = new Cylinder(0.05f + WHEEL_RAD, WHEEL_RAD, 1f, WHEEL_RAD, 1f, 10, true);
    wheel2 = new Cylinder(0.95f - WHEEL_RAD, WHEEL_RAD, 1f, WHEEL_RAD, 1f, 10, true);
    base = new Cube(0.5f, WHEEL_RAD*3, 0.5f, 1f, 1f, WHEEL_RAD*2, false);
  }

  public void draw(GL gl, GLU glu) {
    // Draw floor
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.OUTER_FLOOR]);
    if (Canvas3D.texture_on == false) {
        gl.glColor3f(0f, 3f, 0f);
      } else {
        gl.glColor3f(1f, 1f, 1f);
      }

      gl.glBegin(GL.GL_QUADS);
      gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(x, h1, z + 1);
      gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(x + 1, h2, z + 1);
      gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(x + 1, h3, z);
      gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(x, h4, z);
      gl.glEnd();
	
    
	// Draw the rest
      gl.glTranslatef(x, 0, z);
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.TROOPER]);

    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0f, 0f, 0f);
    } else {
      gl.glColor3f(1f, 1f, 1f);
    }
    
    wheel1.draw(gl, glu);
    wheel2.draw(gl, glu);
    base.draw(gl, glu);

    gl.glTranslatef( -x, -0, -z);
  }

}
