package ngrave.client.objects;

import ssmith.lang.Functions;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Camera;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareTreeSphere extends CMapSquare {

  private static final float TRUNK_HEIGHT = 1.7f;
  private static final float TOP_MAX_RAD=2f, TOP_MIN_RAD=1f;
  private static final float TRUNK_MAX_RAD=0.6f, TRUNK_MIN_RAD=0.4f;

  private float top_radius, trunk_rad;

  public CMapSquareTreeSphere(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.TREE);
    top_radius = Functions.rndFloat(TOP_MIN_RAD, TOP_MAX_RAD);
    trunk_rad = Functions.rndFloat(TRUNK_MIN_RAD, TRUNK_MAX_RAD);
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, 0, z);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.TREE_LEAVES]);
    if (Canvas3D.texture_on) {
      gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    } else {
      gl.glColor3f(0.01f, 0.74f, 0.32f);
    }

    // Tree top
    if (Client.camera.getViewMode() != Camera.VIEW_TOP_DOWN) {
        if (!Client.superfast3d) {
            gl.glTranslatef(0.5f, TRUNK_HEIGHT + TOP_MIN_RAD, 0.5f);
            glu.gluSphere(Canvas3D.quadratic, top_radius, 16, 16);
            gl.glTranslatef( -0.5f, -TRUNK_HEIGHT - TOP_MIN_RAD, -0.5f);
        }
    }
    // Tree trunk
    if (Canvas3D.texture_on) {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    } else {
      gl.glColor3f(0.64f, 0.53f, 0.01f);
    }
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.TREE_TRUNK]);

    gl.glTranslatef(0.5f, TRUNK_HEIGHT, 0.5f);
    gl.glRotatef(90, 1f, 0f, 0f); // We want the trunk to be vertical
    glu.gluCylinder(Canvas3D.quadratic, trunk_rad, trunk_rad, TRUNK_HEIGHT, 8, 1);
    gl.glRotatef(-90, 1f, 0f, 0f);
    gl.glTranslatef(-0.5f, -TRUNK_HEIGHT, -0.5f);

    // Floor
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.OUTER_FLOOR]);

    if (Canvas3D.texture_on) {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    } else {
      gl.glColor3f(0f, 0.4f, 0f);
    }
    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0f, 0f, 1);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(1f, 0f, 1);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1f, 0f, 0);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0f, 0f, 0);
    gl.glEnd();

    gl.glTranslatef(-x, 0, -z);
  }

}
