package ngrave.client.objects;

import ssmith.lang.*;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareRoad extends CMapSquare {

  private static final float MAX_HEIGHT=0.1f;

  private float col;

  public CMapSquareRoad(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.ROAD);
    col = Functions.rndFloat(0.4f, 0.5f);
    calcPolygonCoords();
  }

  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

      gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.ROAD]);

    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0f, col, 0f);
    } else {
        if (!damaged) {
            gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
        } else {
            gl.glColor3f(Client.GREY_DAMAGED, Client.GREY_DAMAGED, Client.GREY_DAMAGED);
        }
    }

    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(x, h1, z + 1);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(x + 1, h2, z + 1);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(x + 1, h3, z);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(x, h4, z);
    gl.glEnd();
  }

  protected void calcPolygonCoords() {
    if (x > 0) {
      h1 = Client.map.getMapSquare((byte) (x-1),(byte) z).h2;
    } else {
      h1 = Functions.rndFloat(0f, MAX_HEIGHT);
    }
    h2 = Functions.rndFloat(0f, MAX_HEIGHT);

    if (z > 0) {
	h3 = Client.map.getMapSquare((byte)x, (byte)(z-1)).h2;
	h4 = Client.map.getMapSquare((byte)x, (byte)(z-1)).h1;
    }
    else {
      h3 = Functions.rndFloat(0f, MAX_HEIGHT);
      h4 = Functions.rndFloat(0f, MAX_HEIGHT);
    }
  }

}
