package ngrave.client.objects;

import java.awt.*;

import ssmith.opengl.Canvas3D;

import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareOpenDoor extends CMapSquare {

  private static final float DOOR_INC = 0.1f;
  private float door_dist=0;
  private float r, g, b;

  public CMapSquareOpenDoor(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.OPEN_DOOR);

    this.door_dist = 1 - DOOR_INC;
    Color col = Color.RED;
    r = col.getRed() / 255f;
    g = col.getGreen() / 255f;
    b = col.getBlue() / 255f;
  }

  public void drawOpenDoor(GL gl, GLU glu) {
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.DOOR]);

    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0.5f, 0.5f, 0.5f);
    } else {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    }

    // Floor
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.INNER_FLOOR]);
    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0, 0, 1f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(1f, 0, 1f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1f, 0, 0);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0, 0, 0);

    // Ceiling
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.CEILING]);
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0f, 1f, 1f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0f, 1f, 0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1f, 1f, 0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(1f, 1f, 1f);

    gl.glEnd();
  }

  private void drawOpeningDoor(GL gl, GLU glu) {
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.DOOR]);

    gl.glBegin(GL.GL_QUADS);
    if (Canvas3D.texture_on == false) {
      gl.glColor3f(r, g, b);
    } else {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    }

    // Front
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, 0.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 0.0f);

    // Right
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, door_dist);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, door_dist);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, 0.0f);

    // back
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, door_dist);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, door_dist);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, door_dist);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, door_dist);

    // left
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0.0f, 0.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, door_dist);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0.0f, 1.0f, door_dist);

    // Ceiling
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f(0, 1f, door_dist);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f(door_dist, 1f, door_dist);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(door_dist, 1f, 0);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(0, door_dist, 0);

  gl.glEnd();

    door_dist = door_dist - DOOR_INC;
  }

  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

      gl.glTranslatef(x, 0, z);
      if (this.door_dist <= 0 || this.door_dist >= 1) {
          drawOpenDoor(gl, glu);
      } else {
          drawOpeningDoor(gl, glu);
          drawOpenDoor(gl, glu);
      }
      gl.glTranslatef(-x, 0, -z);
  }

}
