package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareLockedDoor extends CMapSquare {

  public CMapSquareLockedDoor(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.LOCKED_DOOR);
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, 0, z);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.LOCKED_DOOR]);

    gl.glBegin(GL.GL_QUADS);

    gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);

    // Front/north
      gl.glTexCoord2f(0.0f, 0.0f);
      gl.glVertex3f(0.0f, 1.0f, 0.0f);
      gl.glTexCoord2f(1.0f, 0.0f);
      gl.glVertex3f(1.0f, 1.0f, 0.0f);
      gl.glTexCoord2f(1.0f, 1.0f);
      gl.glVertex3f(1.0f, 0.0f, 0.0f);
      gl.glTexCoord2f(0.0f, 1.0f);
      gl.glVertex3f(0.0f, 0.0f, 0.0f);

    // Right/east
      gl.glTexCoord2f(0.0f, 0.0f);
      gl.glVertex3f(1.0f, 1.0f, 0.0f);
      gl.glTexCoord2f(1.0f, 0.0f);
      gl.glVertex3f(1.0f, 1.0f, 1.0f);
      gl.glTexCoord2f(1.0f, 1.0f);
      gl.glVertex3f(1.0f, 0.0f, 1.0f);
      gl.glTexCoord2f(0.0f, 1.0f);
      gl.glVertex3f(1.0f, 0.0f, 0.0f);

    // back/south
      gl.glTexCoord2f(0.0f, 0.0f);
      gl.glVertex3f(1.0f, 1.0f, 1.0f);
      gl.glTexCoord2f(1.0f, 0.0f);
      gl.glVertex3f(0.0f, 1.0f, 1.0f);
      gl.glTexCoord2f(1.0f, 1.0f);
      gl.glVertex3f(0.0f, 0.0f, 1.0f);
      gl.glTexCoord2f(0.0f, 1.0f);
      gl.glVertex3f(1.0f, 0.0f, 1.0f);

    // left/west
      gl.glTexCoord2f(0.0f, 0.0f);
      gl.glVertex3f(0.0f, 1.0f, 0.0f);
      gl.glTexCoord2f(0.0f, 1.0f);
      gl.glVertex3f(0.0f, 0.0f, 0.0f);
      gl.glTexCoord2f(1.0f, 1.0f);
      gl.glVertex3f(0.0f, 0.0f, 1.0f);
      gl.glTexCoord2f(1.0f, 0.0f);
      gl.glVertex3f(0.0f, 1.0f, 1.0f);

    // Top
    if (Client.camera.isLockedToTrooper() == false) {
      gl.glTexCoord2f(0.0f, 0.0f);
      gl.glVertex3f(0f, 1f, 1f);
      gl.glTexCoord2f(1.0f, 0.0f);
      gl.glVertex3f(1f, 1f, 1f);
      gl.glTexCoord2f(1.0f, 1.0f);
      gl.glVertex3f(1f, 1f, 0f);
      gl.glTexCoord2f(0.0f, 1.0f);
      gl.glVertex3f(0f, 1f, 0f);
    }

    gl.glEnd();

    gl.glTranslatef( -x, -0, -z);

  }

}

