package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

/**
 * Tis is designed to be a giant transparent square.
 */
public class CMapSquareLargeWindow extends CMapSquare {

  public CMapSquareLargeWindow(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.LARGE_WINDOW);
  }

  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

    gl.glTranslatef(x, 0, z);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.EXIT]);

    gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);

    gl.glBegin(GL.GL_QUADS);

    // Front
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(1.0f, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1.0f, 0.0f, 0.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 0.0f);

    gl.glEnd();

    gl.glTranslatef( -x, -0, -z);

  }

}

