package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareFloor extends CMapSquare {

  public CMapSquareFloor(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.FLOOR);
  }

  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

    gl.glTranslatef(x, 0, z);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.INNER_FLOOR]);

    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0.2f, 0.2f, 1f);
    } else {
        if (!damaged) {
            gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
        } else {
            gl.glColor3f(Client.GREY_DAMAGED, Client.GREY_DAMAGED, Client.GREY_DAMAGED);
        }
    }
    // Floor
    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f(0f, 0f, 1f);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f(1f, 0, 1f);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(1f, 0f, 0f);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(0f, 0f, 0f);
    gl.glEnd();

    // Ceiling
      if (Canvas3D.texture_on == false) {
        gl.glColor3f(0f, 1f, 1f);
      } else {
          gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.CEILING]);

              if (!damaged) {
                  gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
              } else {
                  gl.glColor3f(Client.GREY_DAMAGED, Client.GREY_DAMAGED, Client.GREY_DAMAGED);
              }
      }

      gl.glBegin(GL.GL_QUADS);
      gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0f, 1f, 1f);
      gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0f, 1f, 0f);
      gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1f, 1f, 0f);
      gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(1f, 1f, 1f);
    gl.glEnd();

    gl.glTranslatef( -x, -0, -z);
  }

}
