package ngrave.client.objects;

import java.awt.*;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareExit extends CMapSquare {

  public CMapSquareExit(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.EXIT);
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, 0, z);

    if (Canvas3D.texture_on == false) {
      Color col = Color.BLUE;
      gl.glColor3f(col.getRed() / 255, col.getGreen() / 255,
                   col.getBlue() / 255);
    }
    else {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
      gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.EXIT]);
    }

    // Floor
    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f);
    gl.glVertex3f(0f, 0f, 1f);
    gl.glTexCoord2f(1.0f, 0.0f);
    gl.glVertex3f(1f, 0, 1f);
    gl.glTexCoord2f(1.0f, 1.0f);
    gl.glVertex3f(1f, 0f, 0f);
    gl.glTexCoord2f(0.0f, 1.0f);
    gl.glVertex3f(0f, 0f, 0f);

    gl.glEnd();

    gl.glTranslatef( -x, 0, -z);

  }

}
