package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareDefendersComputer extends CMapSquare {

	private static final float HEIGHT = 0.8f;

	//private int texture_no;

  public CMapSquareDefendersComputer(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.DEFENDER_COMPUTER);
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, 0, z);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.DEFENDERS_COMPUTER]);

    if (Canvas3D.texture_on == false) {
      gl.glColor3f(1f, 0f, 1f);
    } else {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    }

    // Front
    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0.0f, HEIGHT, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(1.0f, HEIGHT, 0.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1.0f, 0.0f, 0.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 0.0f);

    // Right
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(1.0f, HEIGHT, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(1.0f, HEIGHT, 1.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1.0f, 0.0f, 1.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(1.0f, 0.0f, 0.0f);

    // back
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(1.0f, HEIGHT, 1.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0.0f, HEIGHT, 1.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 1.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(1.0f, 0.0f, 1.0f);

    // left
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0.0f, HEIGHT, 0.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 1.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0.0f, HEIGHT, 1.0f);

    // Top
    if (Client.camera.isLockedToTrooper() == false) {
      gl.glTexCoord2f(0.0f, 0.0f);
      gl.glVertex3f(0f, HEIGHT, 1f);
      gl.glTexCoord2f(1.0f, 0.0f);
      gl.glVertex3f(1f, HEIGHT, 1f);
      gl.glTexCoord2f(1.0f, 1.0f);
      gl.glVertex3f(1f, HEIGHT, 0f);
      gl.glTexCoord2f(0.0f, 1.0f);
      gl.glVertex3f(0f, HEIGHT, 0f);
    }

    gl.glEnd();

    // Ceiling
    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0f, 1f, 1f);
    } else {
        gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.CEILING]);
        if (!damaged) {
            gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
        } else {
            gl.glColor3f(Client.GREY_DAMAGED, Client.GREY_DAMAGED, Client.GREY_DAMAGED);
        }
    }

    gl.glBegin(GL.GL_QUADS);
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0f, 1f, 1f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0f, 1f, 0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1f, 1f, 0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(1f, 1f, 1f);
    gl.glEnd();


    gl.glTranslatef( -x, 0, -z);

  }

}

