package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.SMapSquare;

public class CMapSquareClosedDoor extends CMapSquare {

  private static final float DOOR_INC = 0.1f;

  //private int texture_no;
  private float door_dist=0;

  public CMapSquareClosedDoor(byte x_pos, byte z_pos) {
    super(x_pos, z_pos, SMapSquare.CLOSED_DOOR);

	door_dist = 1;
    if (Client.map.map[x][z] != null) {
    	// Door was previously an open door, so start to close it
    	if (Client.map.map[x][z].type == SMapSquare.OPEN_DOOR) {
    		door_dist = DOOR_INC;
    	}
    }
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, 0, z);
    drawClosingDoor(gl, glu);
    gl.glTranslatef( -x, -0, -z);
  }

  private void drawClosingDoor(GL gl, GLU glu) {
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.DOOR]);

    gl.glBegin(GL.GL_QUADS);
    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0.5f, 0.5f, 0.5f);
    } else {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    }

    // Front
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, 0.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 0.0f);

    // Right
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, door_dist);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, door_dist);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, 0.0f);

    // back
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(door_dist, 1.0f, door_dist);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, door_dist);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, door_dist);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(door_dist, 0.0f, door_dist);

    // left
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, 0.0f);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, 0.0f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(0.0f, 0.0f, door_dist);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(0.0f, 1.0f, door_dist);

    // Floor
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(0, 0, 1f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(1f, 0, 1f);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(1f, 0, 0);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(0, 0, 0);

    // Ceiling
    if (Client.camera.isLockedToTrooper() == false) {
      gl.glTexCoord2f(0.0f, 0.0f);
      gl.glVertex3f(0, 1f, 1f);
      gl.glTexCoord2f(1.0f, 0.0f);
      gl.glVertex3f(1f, 1f, 1f);
      gl.glTexCoord2f(1.0f, 1.0f);
      gl.glVertex3f(1f, 1f, 0);
      gl.glTexCoord2f(0.0f, 1.0f);
      gl.glVertex3f(0, 1f, 0);
    }
    gl.glEnd();

    if (door_dist < 1) {
      door_dist = door_dist + DOOR_INC;
    }
  }

}

