package ngrave.client.objects;

import java.io.IOException;

import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.server.SMapSquare;

public abstract class CMapSquare {

  public final byte x, z;
  public final byte type;
  protected float h1, h2, h3, h4;
  private boolean can_see = true;
  protected boolean damaged = false;
  protected boolean blocks_movement;
  protected boolean blocks_targetting_view;
  protected boolean blocks_scenery_view;
  
  public static void MapSquareFactory(byte x, byte z, byte type, boolean dam, boolean blocks_move, boolean blocks_targets, boolean blocks_scenery) throws IOException {
  	CMapSquare sq = null;
    switch (type) {
      case SMapSquare.NOTHING:
        sq = new CMapSquareNothing(x, z);
        break;
      case SMapSquare.FLOOR:
      	sq = new CMapSquareFloor(x, z);
        break;
      case SMapSquare.WALL:
      	sq = new CMapSquareWall(x, z);
        break;
      case SMapSquare.TRUCK_TRAILER:
      	sq = new CMapSquareTruckTrailer(x, z);
        break;
      case SMapSquare.GRASS:
      	sq = new CMapSquareGrass(x, z);
        break;
      case SMapSquare.ROAD:
      	sq = new CMapSquareRoad(x, z);
        break;
      case SMapSquare.WATER:
      	sq = new CMapSquareWater(x, z);
        break;
      case SMapSquare.CLOSED_DOOR:
      	sq = new CMapSquareClosedDoor(x, z);
        break;
      case SMapSquare.OPEN_DOOR:
      	sq = new CMapSquareOpenDoor(x, z);
        break;
      case SMapSquare.LOCKED_DOOR:
      	sq = new CMapSquareLockedDoor(x, z);
        break;
      case SMapSquare.WINDOW:
      	sq = new CMapSquareWindow(x, z);
        break;
      case SMapSquare.LARGE_WINDOW:
      	sq = new CMapSquareLargeWindow(x, z);
        break;
      case SMapSquare.ATTACKER_COMPUTER:
      	sq = new CMapSquareAttackersComputer(x, z);
        break;
      case SMapSquare.DEFENDER_COMPUTER:
      	sq = new CMapSquareDefendersComputer(x, z);
        break;
      case SMapSquare.EXIT:
      	sq = new CMapSquareExit(x, z);
        break;
      case SMapSquare.TREE:
      	sq = new CMapSquareTreeSphere(x, z);
        break;
      default:
        System.out.println("Unknown map square for creation: " + type);
      sq = new CMapSquareFloor(x, z);
        break;
    }
    sq.damaged = dam;
    sq.blocks_movement = blocks_move;
    sq.blocks_targetting_view = blocks_targets;
    sq.blocks_scenery_view = blocks_scenery;
  }

  public CMapSquare(byte x, byte z, byte type) { 
    this.type = type;
    this.x = x;
    this.z = z;
    
    if (x>=0 && z>=0) {
    	Client.map.map[x][z] = this;
    }
  }
  
  public boolean blocksMovement() {
      return this.blocks_movement;
  }
  
  public void setCanBeSeen(boolean s) {
      this.can_see = s;
  }
  
  public boolean canBeSeen() {
      return this.can_see;
  }
  
  public abstract void draw(GL gl, GLU glu);

}
