package ngrave.client.objects;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.objects.SGrenade;

public class CGrenade extends CObject {

  public CGrenade(int no, float x, float z, byte owner) {
    super(no, x, 0f, z, 0, owner);
  }

	public boolean shouldBeDrawn() {
		if (this.getOwner() == Client.players.getThisPlayer().side) {
			return true;
		} else {
			return super.shouldBeDrawn();
		}
	}

  public void draw(GL gl, GLU glu) {
      super.moveToPosition(gl);
      // Move down by the HEIGHT so its on the ground
      gl.glTranslatef(0, SGrenade.RADIUS * 2, 0f);
      if (Canvas3D.texture_on == false) {
        gl.glColor3f(1.0f, 0.3f, 0.3f);
      } else {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
      }
      gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.BARREL]);
      glu.gluSphere(Canvas3D.quadratic, SGrenade.RADIUS, 32, 32);
  }

}
