package ngrave.client.objects;

import ssmith.lang.*;
import java.io.*;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;
import ngrave.server.ServerFunctions;
import ngrave.server.Statics;

public class CExplosion extends CObject implements IClientControlled {

  private static final float SIZE = 0.3f, SHARD_SPEED = 0.05f;

  private float off_x, off_y, off_z;
  private int angle = Functions.rnd(0, 360);
  public int move_count=0, max_moves;

  public static void ExplosionFactory(float x, float z, int shards, int size) throws IOException {
    for (int e=0 ; e<shards ; e++) {
      new CExplosion(x, z, size);
    }
    if (size >= ServerFunctions.EXPLOSION_RANGE) {
    	Client.sfx.playSound(Statics.SOUND_DIR + "explosion1.wav");
    }

    /*    if (Client.DEMO) {
    	System.out.println("Explosion with " + shards + " shards.");
    }*/
  }

  private CExplosion(float x, float z, int dist) throws IOException {
    super(-1, x, 0f, z, 0, (byte)-1);
    this.max_moves = (int)(dist / SHARD_SPEED);
    //System.out.println("Explosion: x:" + x + "  z:" + z);
    this.x_pos = x;
    this.z_pos = z;
    this.y_pos = 0.5f;

    off_x = Functions.rndFloat(-SHARD_SPEED, SHARD_SPEED);
    off_y = Functions.rndFloat(-SHARD_SPEED, SHARD_SPEED);
    off_z = Functions.rndFloat(-SHARD_SPEED, SHARD_SPEED);

  }

  public void process() {
    // Move shard
    x_pos = x_pos + off_x;
    y_pos = y_pos + off_y;
    z_pos = z_pos + off_z;

    this.move_count++;
    if (this.move_count > this.max_moves) {
      this.remove();
    }
  }

	public boolean shouldBeDrawn() {
		return true;
	}

  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

    moveToPosition(gl);

    gl.glEnable(GL.GL_BLEND);
    gl.glBlendFunc(GL.GL_ONE, GL.GL_ONE);


    if (Canvas3D.texture_on == false) {
      gl.glColor3f(1.0f, Functions.rndFloat(0f, 0.6f), Functions.rndFloat(0f, 0.6f));
    } else {
      gl.glColor4f(1.0f, 1.0f, 1.0f, 1f);
    }

    //gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.PLASMA1]);
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.STAR]);
    //gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.TREE_TRUNK]);

    gl.glRotatef(angle, 1f, 1f, 1f);
    gl.glBegin(GL.GL_TRIANGLES);
    gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(-SIZE/2, SIZE, -SIZE/2);
    gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(SIZE/2, SIZE, -SIZE/2);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(SIZE/2, 0.0f, -SIZE/2);

    // Rotate 90 deg
    gl.glRotatef(90, 1f, 0f, 0f);
    gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f(-SIZE/2, SIZE, -SIZE/2);
    gl.glTexCoord2f(0.0f, 1.0f);     gl.glVertex3f(SIZE/2, SIZE, -SIZE/2);
    gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f(SIZE/2, 0.0f, -SIZE/2);
    gl.glEnd();

    gl.glDisable(GL.GL_BLEND);

  }

}

