package ngrave.client.objects;

import ssmith.lang.Functions;
import ssmith.opengl.shapes.Cube;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.objects.SCrate;

public class CCrate extends CObject {

  private Cube cube;

  public CCrate(int no, float x, float z) {
    super(no, x, 0f, z, Functions.rnd(0, 359), (byte)-1);
    cube = new Cube(0, SCrate.SIZE/2, 0, SCrate.SIZE, false);
  }

	/*public boolean shouldBeDrawn() {
		return true;
	}*/

  public void draw(GL gl, GLU glu) {
    super.moveToPosition(gl);
    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.CRATE]);

    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0.55f, 0.36f, 0.02f);
    } else {
        gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    }
    cube.draw(gl, glu);
  }

}
