package ngrave.client.objects;

import java.io.IOException;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.Model;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;

public class CCorpseTrooper extends CObject implements IClientControlled {

	private static Model corpse;
	private static final float SCALE = 0.045f;

  public CCorpseTrooper(float x, float z, int ang) throws IOException {
    super(-1, x, 0f, z, ang, (byte)-1);

  }

	/*public boolean shouldBeDrawn() {
		return true;
	}*/

 public void draw(GL gl, GLU glu) {
     if (Client.superfast3d) return;

		try {
			if (corpse == null) {
				corpse = Model.LoadObj("./data/models/Dead.obj", gl, Model.getNextListNo(), SCALE, null);
			}

			super.moveToPosition(gl);

			gl.glTranslatef(0, 0.1f, 0f);
		    //gl.glTranslatef(0.25f, 0f, 0f);

			gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.TROOPER]);
		    gl.glColor3f(0.1f, 0.1f, 0.1f);
		    corpse.render(gl);

		    //gl.glTranslatef(-0.25f, 0f, 0f);
			gl.glTranslatef(0, -0.1f, 0f);

		} catch (IOException e) {
            Client.HandleError(e);
		}



  }

  /* (non-Javadoc)
   * @see ngrave.client.IClientControlled#process()
   */
  public void process() {

  }
}
