package ngrave.client.objects;

import java.io.*;
import java.awt.*;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.shapes.Cylinder;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;
import ngrave.server.objects.SPlayerObjectRobot;

public class CCorpseRobot extends CObject implements IClientControlled {

  private static final float HEIGHT = 0.3f;

  private Cylinder body;
  private float r, g, b;

  public CCorpseRobot(float x, float z, int ang) throws IOException {
    super(-1, x, HEIGHT, z, ang, (byte)-1);

    body = new Cylinder(0f, 0f, 0f, SPlayerObjectRobot.DIAM/2, HEIGHT, 8, false);

    Color col1 = Color.darkGray.darker();
    r = col1.getRed() / 255f;
    g = col1.getGreen() / 255f;
    b = col1.getBlue() / 255f;
  }

	/*public boolean shouldBeDrawn() {
		return true;
	}*/


  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

    super.moveToPosition(gl);

    gl.glColor3f(r, g, b);

    gl.glBindTexture(GL.GL_TEXTURE_2D, Canvas3D.textures.textures[TexLoader.TROOPER]);

    body.draw(gl, glu);

  }

  /* (non-Javadoc)
   * @see ngrave.client.IClientControlled#process()
   */
  public void process() {

  }
}
