package ngrave.client.objects;

import java.io.*;
import ssmith.opengl.shapes.Cube;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;

public class CCorpse extends CObject implements IClientControlled {

  private static final float HEIGHT = 0.3f;

  private Cube corpse;

  public CCorpse(float x, float z, int ang) throws IOException {
    super(-1, x, HEIGHT/2, z, ang, (byte)-1);

    corpse = new Cube(0, HEIGHT/2, 0, HEIGHT, false);
  }

	/*public boolean shouldBeDrawn() {
		return true;
	}*/

 public void draw(GL gl, GLU glu) {
     if (Client.superfast3d) return;

    super.moveToPosition(gl);

    gl.glColor3f(0.1f, 0.1f, 0.1f);

    gl.glBindTexture(GL.GL_TEXTURE_2D,
            Canvas3D.textures.textures[TexLoader.TROOPER]);

    corpse.draw(gl, glu);

  }

  /* (non-Javadoc)
   * @see ngrave.client.IClientControlled#process()
   */
  public void process() {

  }
}
