package ngrave.client.objects;

import java.io.IOException;
import ssmith.opengl.shapes.Cube;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.IClientControlled;
import ngrave.client.TexLoader;

public class CChair extends CObject implements IClientControlled {

  private static final float SEAT_HEIGHT = 0.3f, SEAT_DEPTH = 0.3f;

  private Cube seat, back;

  public CChair(float x, float z, int y_ang) throws IOException {
    super(-1, x, 0f, z, y_ang, (byte)-1);

//    this.x_pos = x+0.5f;
 //   this.z_pos = z+0.5f;

    this.setLocation(x + 0.5f, z + 0.5f);
    this.y_pos = 0;
    this.y_angle = y_ang;

    seat = new Cube(0, SEAT_HEIGHT/2, 0, SEAT_DEPTH, false);
    back = new Cube(0, SEAT_HEIGHT, SEAT_DEPTH/2, 0.1f, SEAT_DEPTH, SEAT_HEIGHT*2, false);

  }

	/*public boolean shouldBeDrawn() {
		return true;
	}*/

  public void draw(GL gl, GLU glu) {
      if (Client.superfast3d) return;

    super.moveToPosition(gl);

    if (Canvas3D.texture_on) {
      gl.glBindTexture(GL.GL_TEXTURE_2D,
                       Canvas3D.textures.textures[TexLoader.FURNITURE]);
    }
    gl.glColor3f(.25f, 0.1f, 0.84f);


    seat.draw(gl, glu);
    back.draw(gl, glu);
  }

/* (non-Javadoc)
 * @see ngrave.client.IClientControlled#process()
 */
public void process() {

}

}
