package ngrave.client.objects;

import ssmith.opengl.shapes.Cylinder;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.TexLoader;

public class CBulletTrail extends CObject {

  private Cylinder cyl;

  public CBulletTrail(int no, float x, float z, int y_ang, byte owner) {
    super(no, x, 0.5f, z, y_ang, owner);
    cyl = new Cylinder(0f, 0f, 0f, 0.1f, 0.15f, 6, true);
  }

  public void remove() {
	super.remove();
  }

  public void draw(GL gl, GLU glu) {
      super.moveToPosition(gl);

      gl.glEnable(GL.GL_BLEND);
      gl.glBlendFunc(GL.GL_ONE, GL.GL_ONE);

      if (Canvas3D.texture_on == false) {
        gl.glColor4f(0.5f, 0.15f, 0.15f, 1f);
      } else {
        gl.glColor4f(0.8f, 0.8f, 0.8f, 1f);
      }
      gl.glBindTexture(GL.GL_TEXTURE_2D,
                         Canvas3D.textures.textures[TexLoader.PLASMA1]);

      cyl.draw(gl, glu);

      gl.glDisable(GL.GL_BLEND);
    }


}
