package ngrave.client.objects;

import ssmith.opengl.shapes.Cylinder;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.Statics;

public class CBullet extends CObject {

  private Cylinder cyl;
  private static int no_of_bullets=0;

  public CBullet(int no, float x, float z, int y_ang, byte owner) {
    super(no, x, 0.5f, z, y_ang, owner);
    cyl = new Cylinder(0f, 0f, 0f, 0.06f, 0.4f, 6, true);

	Client.sfx.playSound(Statics.SOUND_DIR + "laser" + (owner+1) + ".wav");
	
    no_of_bullets++;
  }

  public void remove() {
	  super.remove();
	  no_of_bullets--;
  }
  
  public static boolean IsBullets() {
	  return no_of_bullets > 0;
  }
  
  public void draw(GL gl, GLU glu) {
      super.moveToPosition(gl);

      gl.glEnable(GL.GL_BLEND);
      gl.glBlendFunc(GL.GL_ONE, GL.GL_ONE);

      if (Canvas3D.texture_on == false) {
        gl.glColor3f(1.0f, 0.3f, 0.3f);
      } else {
        gl.glColor3f(1.0f, 1.0f, 1.0f);
      }
      gl.glBindTexture(GL.GL_TEXTURE_2D,
                         Canvas3D.textures.textures[TexLoader.PLASMA1]);

      cyl.draw(gl, glu);

      gl.glDisable(GL.GL_BLEND);
    }


}
