package ngrave.client.objects;

import ssmith.opengl.shapes.Cylinder;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.server.objects.SBarrel;

public class CBarrel extends CObject {

  private Cylinder cyl;

  public CBarrel(int no, float x, float z) {
    super(no, x, 0f, z, 0, (byte)-1);
    cyl = new Cylinder(0, SBarrel.HEIGHT, 0, SBarrel.RADIUS, SBarrel.HEIGHT, 10, false);
  }

	/*public boolean shouldBeDrawn() {
		return true;
	}*/

  public void draw(GL gl, GLU glu) {
    gl.glBindTexture(GL.GL_TEXTURE_2D,
                   Canvas3D.textures.textures[TexLoader.BARREL]);

    if (Canvas3D.texture_on == false) {
      gl.glColor3f(0.59f, 0.066f, 1f);
    } else {
      gl.glColor3f(Client.GREY, Client.GREY, Client.GREY);
    }
    super.moveToPosition(gl);
    cyl.draw(gl, glu);
  }

}
