package ngrave.client.menus;

import java.io.IOException;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import ngrave.client.C2SCommunication;
import ngrave.client.Client;
import ngrave.server.objects.SPlayerObject3D;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.menu.GLMenuLabel;
import ssmith.opengl.menu.GLMenuMultiToggle;
import ssmith.opengl.menu.GLMenuSelect;
import ssmith.opengl.menu.GLMenuItem;
import ssmith.opengl.menu.GLMenu;

public class mnuUnitOptions extends GLMenu {
	
	private GLMenuMultiToggle shot_type = new GLMenuMultiToggle("Shot Type:");
	private GLMenuLabel help = new GLMenuLabel("");
	private static int last_option_selected = 0;

    public mnuUnitOptions(Canvas3D canv) {
        super(canv, Client.GL_FONT, Client.MENU_RED, Client.MENU_GREEN, Client.MENU_BLUE);
        
        shot_type.addOption("Snapshot", Client.current_unit.getShotType() == SPlayerObject3D.SNAP_SHOT);
        shot_type.addOption("Normal", Client.current_unit.getShotType() == SPlayerObject3D.NORMAL_SHOT);
        shot_type.addOption("Aimed Shot", Client.current_unit.getShotType() == SPlayerObject3D.AIMED_SHOT);

        this.addMenuItem(shot_type);
        if (Client.current_unit.isAutofiring()) {
            this.addMenuItem(new GLMenuSelect("Stop Autofiring"));
        } else {
            this.addMenuItem(new GLMenuSelect("Start Autofiring"));
        }
        if (Client.current_unit.isGuarding()) {
            this.addMenuItem(new GLMenuSelect("Stop Guarding"));
        } else {
            this.addMenuItem(new GLMenuSelect("Start Guarding"));
        }
        this.addMenuItem(new GLMenuSelect("Action"));
        this.addMenuItem(new GLMenuSelect("Change Item"));
        this.addMenuItem(new GLMenuSelect("Reload"));
        //this.addMenuItem(new GLMenuSelect("Give AI")); todo
        this.addMenuItem(new GLMenuSelect("Return"));
        this.addMenuItem(help);
        
        this.highlightItem(last_option_selected);
    }

	public void draw(GL gl, GLU glu, int x) {
		//todo - add help text
		super.draw(gl, glu, x);
	}
	
    protected void menuItemSelected(GLMenuItem menu_item) {
    	last_option_selected = this.getIndexOfMenuItem(menu_item);
    	try {
    		Client.current_unit.setShotType(shot_type.getSelectedOption());
	        if (menu_item.menu_text.equalsIgnoreCase("Change Item")) {
	            Client.removeMenu();
	            Client.showChangeItemSelector();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Reload")) {
	            Client.Reload();
	            Client.removeMenu();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Action")) {
	            C2SCommunication.SendAction(Client.current_unit);
	            Client.removeMenu();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Stop Autofiring")) {
	            Client.current_unit.setAutofire(false, true);
	            Client.removeMenu();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Start Autofiring")) {
	            Client.current_unit.setAutofire(true, true);
	            Client.removeMenu();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Stop Guarding")) {
	            Client.current_unit.setGuard(false, true);
	            Client.removeMenu();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Start Guarding")) {
	            Client.current_unit.setGuard(true, true);
	            Client.removeMenu();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Give AI")) {
	            Client.removeMenu();
	            //todo - C2SCommunication.SendAIForUnit();
	        } else if (menu_item.menu_text.equalsIgnoreCase("Return")) {
	            Client.removeMenu();
	        }
    	} catch (IOException ex) {
    		Client.HandleError(ex);
    	}
    }

}
