package ngrave.client.menus;

import ssmith.opengl.menu.GLMenu;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.menu.GLMenuItem;
import ssmith.opengl.menu.GLMenuSelect;
import ssmith.opengl.menu.GLMenuText;
import java.io.*;

import ngrave.client.C2SCommunication;
import ngrave.client.Client;

public final class mnuSendMessage extends GLMenu {

    private GLMenuText all_text, my_side_text;

    public mnuSendMessage(Canvas3D canv) {
        super(canv, Client.GL_FONT, Client.MENU_RED, Client.MENU_GREEN, Client.MENU_BLUE);

        my_side_text = new GLMenuText("Message To Own Side:");
        all_text = new GLMenuText("Message To All Players:");

        this.addMenuItem(my_side_text);
        this.addMenuItem(all_text);
        this.addMenuItem(new GLMenuSelect("Send"));
        this.addMenuItem(new GLMenuSelect("Cancel"));
    }

    protected void menuItemSelected(GLMenuItem menu_item) {
        if (menu_item.menu_text.equalsIgnoreCase("Send")) {
            try {
                if (all_text.getText().length() > 0) {
                    C2SCommunication.SendMessage(all_text.getText(), false);
                }
                if (my_side_text.getText().length() > 0) {
                    C2SCommunication.SendMessage(my_side_text.getText(), true);
                }
            } catch (IOException ex) {
                Client.HandleError(ex);
            }
        }
        Client.removeMenu();
    }


}
