/*
 * Created on 16-Nov-2006
 *
 */
package ngrave.client.menus;

import ngrave.client.Client;
import ngrave.client.QuadByte;
import ssmith.lang.Functions;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.menu.GLMenu;
import ssmith.opengl.menu.GLMenuItem;
import ssmith.opengl.menu.GLMenuLabel;
import ssmith.opengl.menu.GLMenuSelect;

public class mnuSelectSide extends GLMenu {

    private String att_opt, def_opt;

    public mnuSelectSide(Canvas3D canv, QuadByte qbyte) {
        super(canv, Client.GL_FONT, Client.MENU_RED, Client.MENU_GREEN, Client.MENU_BLUE);

        int tot = (qbyte.b - qbyte.a);
        tot = Functions.mod(tot); // In case there are some players connected but no free units (so the tot will be negative)
        att_opt = "Attackers: " + tot + " free slots";
        if (tot == 0) {
        	att_opt = att_opt + " (CPU Controlled)";
        }
        tot = (qbyte.d - qbyte.c);
        tot = Functions.mod(tot); // In case there are some players connected but no free units (so the tot will be negative)
        def_opt = "Defenders: " + tot + " free slots";
        if (tot == 0) {
        	def_opt = def_opt + " (CPU Controlled)";
        }
        this.addMenuItem(new GLMenuLabel("Please use the up/down arrow keys and enter to select your side:"));
        this.addMenuItem(new GLMenuSelect(att_opt));
        this.addMenuItem(new GLMenuSelect(def_opt));
    }

    protected void menuItemSelected(GLMenuItem menu_item) {
    	// When we set the side, this will trigger the Client class to send it to the server
        if (menu_item.menu_text.equalsIgnoreCase(att_opt)) {
            Client.players.getThisPlayer().side = Client.ATTACKER;
        } else {
            Client.players.getThisPlayer().side = Client.DEFENDER;
        }
        Client.removeMenu();
    }


}
