package ngrave.client.menus;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.menu.GLMenu;
import ssmith.opengl.menu.GLMenuItem;
import ssmith.opengl.menu.GLMenuLabel;
import ssmith.opengl.menu.GLMenuSelect;
import java.util.ListIterator;

import ngrave.client.CPlayerData;
import ngrave.client.Client;

public final class mnuListPlayers extends GLMenu {

	public mnuListPlayers(Canvas3D canv) {
        super(canv, Client.GL_FONT, Client.MENU_RED, Client.MENU_GREEN, Client.MENU_BLUE);

        this.addMenuItem(new GLMenuLabel("The following players are connected:-"));
        ListIterator it = Client.players.getIterator();
        while (it.hasNext()) {
        	CPlayerData player = (CPlayerData)it.next();
            String side = " (Attacker)";
            if (player.side == Client.DEFENDER) {
                side = " (Defender)";
            }
            this.addMenuItem(new GLMenuLabel(player.getName() + side));

        }
        this.addMenuItem(new GLMenuSelect("Exit"));
	}

    protected void menuItemSelected(GLMenuItem menu_item) {
    	if (menu_item.menu_text.equals("Exit")) {
    		Client.removeMenu();
    	}
    }

}
